/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.io.Player;
import com.idtechproducts.device.audiojack.io.RWaveParser;
import com.idtechproducts.device.audiojack.io.Recorder;
import com.idtechproducts.device.audiojack.io.TonePlayer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOManager
implements RWaveParser.Client {
    private static final String TAG = "SDK::IOMan";
    private final Context _context;
    private final TonePlayer _tonePlayer;
    private Player _player;
    private final Recorder _recorder;
    private final RWaveParser _rWaveParser;
    protected final OnReceiverListener _umrMsg;
    private String _rWaveParserLogPrefix;
    private StructConfigParameters _cfg_config;
    private boolean _cfg_logging;
    private List<byte[]> _rpd_responseParseResults = null;
    private ResponseProcessor _rpd_responseProcessor;
    private IDT_Device.TaskExport _taskExport;
    boolean attached = false;
    public boolean isForceTerminateTask = false;
    private Object mutexNotifyDataReady = new Object();
    private Object mutexNotifyTaskDown = new Object();
    RecordRunnable recordRunnable = null;
    boolean isRecording = false;
    public static OnReceiverListener emvListener = null;

    public IOManager(OnReceiverListener umrMsg, Context context, IDT_Device.TaskExport taskExport) {
        if (context == null) {
            throw new NullPointerException();
        }
        this._taskExport = taskExport;
        this._context = context;
        this._umrMsg = umrMsg;
        this._tonePlayer = new TonePlayer();
        this._player = new Player(taskExport.getReaderType());
        this._recorder = new Recorder(context);
        this._rWaveParser = new RWaveParser(this);
        this._rWaveParser.setLog(false, false);
        this._rWaveParserLogPrefix = String.valueOf(Common.getDir_externalOrSandbox(context).getAbsolutePath()) + "/IDT_Log_Wave";
        this._cfg_config = null;
        this._cfg_logging = false;
    }

    public void release() {
        this._tonePlayer.release();
        this._player.release();
        this._recorder.release();
    }

    public void setAttached(boolean attached) {
        this.attached = attached;
    }

    public void resetPlayer() {
        this._tonePlayer.release();
        this._player.release();
        this._player = new Player(this._taskExport.getReaderType());
        if (this._cfg_config != null) {
            this._player.setConfig(this._cfg_config);
        }
    }

    public void setConfig(StructConfigParameters config) {
        if (config == null) {
            this._cfg_config = null;
            return;
        }
        this.stopRecordThread();
        this._cfg_config = config.clone();
        this._tonePlayer.setConfig(this._cfg_config);
        this._player.setConfig(config);
        this._recorder.setConfig(config);
        this._rWaveParser.setSamplingRate(config.getFrequenceInput());
        this._rWaveParser.setBaud(config.getBaudRate());
        if (Build.MODEL.equalsIgnoreCase("samsung-sgh-i337")) {
            this._rWaveParser.setSdThresholdResolve(true, false);
        }
        if (this.attached) {
            this.startRecordThread();
        }
    }

    public StructConfigParameters getConfigCopy() {
        return this._cfg_config != null ? this._cfg_config.clone() : null;
    }

    public void setSaveLog(boolean enabled) {
        this._cfg_logging = enabled;
        this._rWaveParser.setLog(enabled, false);
    }

    public int deleteLogs() {
        int r = 0;
        File logDir = new File(this._rWaveParserLogPrefix).getParentFile();
        if (logDir != null && logDir.isDirectory()) {
            File[] loglist = logDir.listFiles();
            int i = 0;
            while (loglist != null && i < loglist.length) {
                String name = loglist[i].getName();
                if (name.endsWith(".wav") && name.startsWith("IDT_Log_")) {
                    loglist[i].delete();
                    ++r;
                }
                if (name.endsWith(".txt") && name.startsWith("IDT_Log")) {
                    loglist[i].delete();
                    ++r;
                }
                ++i;
            }
        }
        return r;
    }

    public void setDeviceMediaVolumeToMax() {
        short minus;
        short s = minus = this._cfg_config != null ? this._cfg_config.getVolumeLevelAdjust() : (short)0;
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            this.setDeviceMediaVolumeToMaxMinusArg(minus == 0 ? 2 : (int)minus);
        } else {
            this.setDeviceMediaVolumeToMaxMinusArg(minus);
        }
    }

    public void setDeviceMediaVolumeToMaxMinusArg(int minus) {
        AudioManager audioManager = (AudioManager)this._context.getSystemService("audio");
        int max = audioManager.getStreamMaxVolume(3);
        int newVolume = max - (minus > 0 ? minus : 0);
        int currentVol = audioManager.getStreamVolume(3);
        if (currentVol != newVolume) {
            audioManager.setStreamVolume(3, newVolume, 0);
            currentVol = audioManager.getStreamVolume(3);
        }
    }

    public TonePlayer getTonePlayer() {
        return this._tonePlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RPDResult recordPlayDecode(byte[] cmdString, double waitLen, ICancel icancel, ResponseProcessor rproc, boolean recordAfterPlay, boolean maximizeVolumeAfterPlay, boolean withPlay) {
        boolean flag_hasTimedOut;
        boolean flag_haslowLevelFailure;
        boolean flag_isCanceled;
        block43: {
            if (this._cfg_config == null) {
                throw new IllegalStateException("not configured");
            }
            flag_isCanceled = icancel.isCanceled();
            flag_haslowLevelFailure = false;
            flag_hasTimedOut = false;
            if (!flag_isCanceled) {
                try {
                    try {
                        this._rWaveParser.logClear();
                        this._rWaveParser.logBegin();
                        if (!this.isRecording() && !recordAfterPlay) {
                            this.stopRecordThread();
                            this.startRecordThread();
                        }
                        if (cmdString != null) {
                            if (this._cfg_config.getForceHeadsetPlug() == 1) {
                                try {
                                    Thread.sleep(700L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (withPlay) {
                                this._player.startPlayingCommand(cmdString);
                            }
                            this.setDeviceMediaVolumeToMax();
                            if (!this.isRecording() && recordAfterPlay) {
                                this.stopRecordThread();
                                this.startRecordThread();
                            }
                        }
                        this._rpd_responseProcessor = rproc;
                        if (icancel.isCanceled()) {
                            flag_isCanceled = true;
                        }
                        long timeLimit = (long)(waitLen * 1000.0);
                        boolean shouldStop = false;
                        long timeBegin = System.currentTimeMillis();
                        do {
                            List<byte[]> list;
                            if (this.mutexNotifyDataReady != null) {
                                list = this.mutexNotifyDataReady;
                                synchronized (list) {
                                    block42: {
                                        try {
                                            this.mutexNotifyDataReady.wait(timeLimit);
                                            if (this.isForceTerminateTask) {
                                                this.isForceTerminateTask = false;
                                                flag_isCanceled = true;
                                                break;
                                            }
                                            if (!icancel.isCanceled()) break block42;
                                            flag_isCanceled = true;
                                            break;
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (System.currentTimeMillis() - timeBegin >= timeLimit) {
                                shouldStop = true;
                                flag_hasTimedOut = true;
                            }
                            list = this._rpd_responseParseResults;
                            synchronized (list) {
                                if (!this._rpd_responseParseResults.isEmpty()) {
                                    shouldStop = rproc.processResponse(this._rpd_responseParseResults);
                                }
                            }
                        } while (!shouldStop);
                    }
                    catch (Exception ex) {
                        flag_haslowLevelFailure = true;
                        if (withPlay) {
                            this._player.stopCommand();
                        }
                        if (this._cfg_logging && flag_hasTimedOut) {
                            String fileName = String.valueOf(this._rWaveParserLogPrefix) + new SimpleDateFormat("MM.dd_HH-mm-ss", Locale.US).format(new Date());
                            this._rWaveParser.setLogFilePrefix(fileName);
                            this._rWaveParser.saveLoggedData();
                            this._rWaveParser.logClear();
                        }
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    if (withPlay) {
                        this._player.stopCommand();
                    }
                    if (this._cfg_logging && flag_hasTimedOut) {
                        String fileName = String.valueOf(this._rWaveParserLogPrefix) + new SimpleDateFormat("MM.dd_HH-mm-ss", Locale.US).format(new Date());
                        this._rWaveParser.setLogFilePrefix(fileName);
                        this._rWaveParser.saveLoggedData();
                        this._rWaveParser.logClear();
                    }
                    throw throwable;
                }
                if (withPlay) {
                    this._player.stopCommand();
                }
                if (this._cfg_logging && flag_hasTimedOut) {
                    String fileName = String.valueOf(this._rWaveParserLogPrefix) + new SimpleDateFormat("MM.dd_HH-mm-ss", Locale.US).format(new Date());
                    this._rWaveParser.setLogFilePrefix(fileName);
                    this._rWaveParser.saveLoggedData();
                    this._rWaveParser.logClear();
                }
            }
        }
        RPDResult ret = new RPDResult();
        ret.packetDetected = this._rWaveParser.isPacketDetected();
        ret.data = null;
        if (flag_isCanceled) {
            ret.status = RPDStatus.CANCELED;
        } else if (flag_hasTimedOut) {
            ret.status = RPDStatus.TIMEDOUT;
        } else if (flag_haslowLevelFailure || this._rpd_responseParseResults.isEmpty()) {
            ret.status = RPDStatus.FAILED;
        } else {
            ret.status = RPDStatus.PARSED;
            ret.packetDetected = true;
            ret.data = this._rpd_responseParseResults;
        }
        this._rpd_responseProcessor = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIoManager() {
        if (this.mutexNotifyDataReady != null) {
            Object object = this.mutexNotifyDataReady;
            synchronized (object) {
                this.mutexNotifyDataReady.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskFinished() {
        if (this._rpd_responseParseResults != null) {
            this._rpd_responseParseResults.clear();
        }
        if (this.mutexNotifyTaskDown != null) {
            Object object = this.mutexNotifyTaskDown;
            synchronized (object) {
                this.mutexNotifyTaskDown.notifyAll();
            }
        }
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void startRecordThread() {
        if (this.isRecording) {
            this.stopRecordThread();
        }
        this.isRecording = true;
        this.recordRunnable = new RecordRunnable();
        this.recordRunnable.start();
    }

    public void stopRecordThread() {
        if (!this.isRecording) {
            return;
        }
        this.isRecording = false;
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (this.recordRunnable != null) {
            while (this.recordRunnable.isAlive()) {
                try {
                    this.recordRunnable.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.recordRunnable = null;
        }
    }

    @Override
    public boolean processParsedData(byte[] response) {
        this._rpd_responseParseResults.add(response);
        return true;
    }

    public static void setEMVListener(OnReceiverListener callback) {
        emvListener = callback;
    }

    @Override
    public void soundDetected() {
        if (this._rpd_responseProcessor != null) {
            this._rpd_responseProcessor.processSound();
        }
    }

    private boolean filterICCNotification(List<byte[]> response) {
        boolean isNotificationResp = false;
        for (byte[] respI : response) {
            if (respI.length < 2 || 2 != respI[0] || 3 != respI[respI.length - 1] || respI.length <= 6) continue;
            short respLength = (short)(respI[2] & 0xFF);
            if (respI.length != (respLength = (short)(respLength << 8 & 0xFF00 | respI[1] & 0xFF)) + 6 || respLength != 2 || respI[3] != 78) continue;
            isNotificationResp = true;
            switch (respI[4]) {
                case 0: {
                    this._umrMsg.ICCNotifyInfo(respI, "ICC Card Not Seated.");
                    if (emvListener == null) break;
                    emvListener.ICCNotifyInfo(respI, "ICC Card Not Seated.");
                    break;
                }
                case 1: {
                    this._umrMsg.ICCNotifyInfo(respI, "ICC Card Seated.");
                    if (emvListener == null) break;
                    emvListener.ICCNotifyInfo(respI, "ICC Card Seated.");
                    break;
                }
                case 17: {
                    this.isForceTerminateTask = true;
                    this.mutexNotifyDataReady.notifyAll();
                    this._umrMsg.ICCNotifyInfo(respI, "ICC Card Seated and Disable Swipe MSR Card");
                    if (emvListener == null) break;
                    emvListener.ICCNotifyInfo(respI, "ICC Card Seated and Disable Swipe MSR Card");
                    break;
                }
                case 16: {
                    this._umrMsg.ICCNotifyInfo(respI, "ICC Card Not Seated and Power off ICC.");
                    if (emvListener == null) break;
                    emvListener.ICCNotifyInfo(respI, "ICC Card Not Seated and Power off ICC.");
                    break;
                }
                case 32: {
                    this._umrMsg.msgBatteryLow();
                    break;
                }
                default: {
                    this._umrMsg.ICCNotifyInfo(respI, "ICC Card Seated status changed.");
                    if (emvListener == null) break;
                    emvListener.ICCNotifyInfo(respI, "ICC Card Seated status changed.");
                }
            }
            this._rpd_responseParseResults.clear();
        }
        return isNotificationResp;
    }

    public static interface ICancel {
        public boolean isCanceled();
    }

    public static class RPDResult {
        public RPDStatus status;
        public boolean packetDetected;
        public List<byte[]> data;
        public byte[] lastMatch;

        public boolean isParsed() {
            return this.status == RPDStatus.PARSED;
        }

        public boolean isTimedOut() {
            return this.status == RPDStatus.TIMEDOUT;
        }

        public boolean isCanceledOrFailed() {
            return this.status == RPDStatus.CANCELED || this.status == RPDStatus.FAILED;
        }

        public boolean matches(String pattern) {
            if (this.data == null) {
                throw new RuntimeException("no parsed data");
            }
            for (byte[] ba : this.data) {
                if (!Common.bytesMatch(ba, pattern)) continue;
                this.lastMatch = ba;
                return true;
            }
            return false;
        }

        public boolean matches(byte[] byteString) {
            if (this.data == null) {
                throw new RuntimeException("no parsed data");
            }
            for (byte[] ba : this.data) {
                if (!Arrays.equals(ba, byteString)) continue;
                this.lastMatch = ba;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RPDStatus {
        PARSED,
        TIMEDOUT,
        CANCELED,
        FAILED;

    }

    class RecordRunnable
    extends Thread {
        RecordRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block28: {
                this.setName("Decode Background");
                boolean cfg_releaseRecorderAfterEachUse = true;
                boolean dbgFlag_hasRecordedSomething = false;
                try {
                    try {
                        if (IOManager.this._cfg_config == null) {
                            throw new IllegalStateException("not configured");
                        }
                        IOManager.this._recorder.setConfig(IOManager.this._cfg_config);
                        IOManager.this._recorder.start();
                        BlockingQueue<short[]> recQ = IOManager.this._recorder.getDataQueue();
                        IOManager.this._rWaveParser.purge();
                        IOManager.this._rpd_responseParseResults = new ArrayList();
                        long timeBegin = System.currentTimeMillis();
                        long lastTime = 0L;
                        while (IOManager.this.isRecording) {
                            short[] chunk = null;
                            int countNull = 0;
                            do {
                                if (!IOManager.this.isRecording) {
                                } else {
                                    try {
                                        chunk = recQ.poll(250L, TimeUnit.MILLISECONDS);
                                        long data = (System.currentTimeMillis() - timeBegin) / 5000L;
                                        if (lastTime < data) {
                                            lastTime = data;
                                        }
                                        countNull = chunk == null ? ++countNull : 0;
                                        if (countNull <= 0 || System.currentTimeMillis() - timeBegin < 4000L) continue;
                                    }
                                    catch (InterruptedException e) {}
                                }
                                break block28;
                            } while (chunk == null && IOManager.this.isRecording);
                            dbgFlag_hasRecordedSomething = true;
                            if (!IOManager.this.isRecording) break;
                            if (chunk == null) {
                                break;
                            }
                            IOManager.this._rWaveParser.parseWaveData(chunk, chunk.length);
                            chunk = null;
                            if (IOManager.this._rpd_responseParseResults.isEmpty()) continue;
                            boolean needWaitNotify = false;
                            if (IOManager.this.mutexNotifyDataReady != null) {
                                Object object = IOManager.this.mutexNotifyDataReady;
                                synchronized (object) {
                                    if (!IOManager.this.filterICCNotification(IOManager.this._rpd_responseParseResults)) {
                                        if (IOManager.this._cfg_logging) {
                                            String fileName = String.valueOf(IOManager.this._rWaveParserLogPrefix) + new SimpleDateFormat("MM.dd_HH-mm-ss", Locale.US).format(new Date());
                                            IOManager.this._rWaveParser.setLogFilePrefix(fileName);
                                            IOManager.this._rWaveParser.saveLoggedData();
                                            IOManager.this._rWaveParser.logClear();
                                        }
                                        IOManager.this.mutexNotifyDataReady.notifyAll();
                                        needWaitNotify = true;
                                    }
                                }
                            }
                            if (!needWaitNotify) continue;
                            Thread.sleep(10L);
                            long timeBegin1 = System.currentTimeMillis();
                            if (IOManager.this.mutexNotifyTaskDown != null) {
                                Object object = IOManager.this.mutexNotifyTaskDown;
                                synchronized (object) {
                                    try {
                                        IOManager.this.mutexNotifyTaskDown.wait(300L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    continue;
                                }
                            }
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        IOManager.this._recorder.stop();
                        IOManager.this._recorder.release();
                        IOManager.this.isRecording = false;
                    }
                }
                finally {
                    IOManager.this._recorder.stop();
                    IOManager.this._recorder.release();
                    IOManager.this.isRecording = false;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResponseProcessor {
        public boolean processResponse(List<byte[]> var1);

        public void processSound();
    }
}

