/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import android.content.Context;
import com.idtechproducts.device.ErrorCodeInfo;
import com.idtechproducts.device.Gen2DataStruct;
import com.idtechproducts.device.ICCReaderStatusStruct;
import com.idtechproducts.device.IDTEMVData;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.OnReceiverListenerGen2;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDT_VP8800 {
    private static IDT_Device device;

    public static IDT_Device getSDKInstance() {
        return device;
    }

    public IDT_VP8800(OnReceiverListener callback, Context context) {
        device = new IDT_Device(callback, context);
        if (IDT_Device.getUSBBypass()) {
            IDT_Device._bypassDevice = ReaderInfo.DEVICE_TYPE.DEVICE_VP8800;
        } else {
            device.device_setDeviceType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800);
        }
    }

    public int device_sendGen2Cmd(byte[] encPayload, byte[] payloadMac, Gen2DataStruct respData, int timeout) {
        return device.device_sendGen2Cmd(encPayload, payloadMac, respData, timeout);
    }

    public int device_cancelGen2Transaction() {
        return device.device_cancelGen2Transaction();
    }

    public static void useUSBIntentFilter() {
        IDT_Device._isDeviceFilter = true;
    }

    public boolean device_setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            return device.device_setDeviceType(ReaderInfo.DEVICE_TYPE.DEVICE_VP8800);
        }
        return false;
    }

    public boolean device_disconnectBLE() {
        return device.device_disconnectBLE();
    }

    public int device_enableBLESearch(ReaderInfo.DEVICE_TYPE type, String name, int timeout) {
        return device.device_enableBLESearch(type, name, timeout);
    }

    public String getBTLEDeviceAddress() {
        return device.getBTLEDeviceAddress();
    }

    public void setGen2Callback(OnReceiverListenerGen2 callback) {
        if (device == null) {
            return;
        }
        device.setGen2Callback(callback);
    }

    public int expireSessionKeys(Gen2DataStruct respData) {
        if (device == null) {
            return 1;
        }
        return device.expireSessionKeys(respData);
    }

    public int removeEnrollment(Gen2DataStruct respData) {
        if (device == null) {
            return 1;
        }
        return device.removeEnrollment(respData);
    }

    public int getSessionKeyStatus(Gen2DataStruct respData) {
        if (device == null) {
            return 1;
        }
        return device.getSessionKeyStatus(respData);
    }

    public int startVTRTPolling(byte timeout, Gen2DataStruct respData) {
        if (device == null) {
            return 1;
        }
        return device.startVTRTPolling(timeout, respData);
    }

    public int cancelVTRTPolling(Gen2DataStruct respData) {
        if (device == null) {
            return 1;
        }
        return device.cancelVTRTPolling(respData);
    }

    public int startVTRT(byte[] data, Gen2DataStruct respData) {
        if (device == null) {
            return 1;
        }
        return device.startVTRT(data, respData);
    }

    public int finalizeVTRT(byte[] data, Gen2DataStruct respData) {
        if (device == null) {
            return 1;
        }
        return device.finalizeVTRT(data, respData);
    }

    public int startSession(byte[] data, Gen2DataStruct respData) {
        if (device == null) {
            return 1;
        }
        return device.startSession(data, respData);
    }

    public int finalizeSession(byte[] data, Gen2DataStruct respData) {
        if (device == null) {
            return 1;
        }
        return device.finalizeSession(data, respData);
    }

    public void setIDT_Device(FirmwareUpdateTool fwTool) {
        device.setIDT_Device(fwTool);
    }

    public ReaderInfo.DEVICE_TYPE device_getDeviceType() {
        return device.device_getDeviceType();
    }

    public void registerListen() {
        device.registerListen();
    }

    public static IDT_Device getIDT_Device() {
        return device;
    }

    public void unregisterListen() {
        device.unregisterListen();
    }

    public void release() {
        device.release();
    }

    public String config_getSDKVersion() {
        return device.config_getSDKVersion();
    }

    public String config_getXMLVersionInfo() {
        return device.config_getXMLVersionInfo();
    }

    public String phone_getInfoManufacture() {
        return device.phone_getInfoManufacture();
    }

    public String phone_getInfoModel() {
        return device.phone_getInfoModel();
    }

    public void log_setVerboseLoggingEnable(boolean enable) {
        device.log_setVerboseLoggingEnable(enable);
    }

    public void log_setSaveLogEnable(boolean enable) {
        device.log_setSaveLogEnable(enable);
    }

    public int log_deleteLogs() {
        return device.log_deleteLogs();
    }

    public void config_setXMLFileNameWithPath(String path) {
        device.config_setXMLFileNameWithPath(path);
    }

    public boolean config_loadingConfigurationXMLFile(boolean updateAutomatically) {
        return device.config_loadingConfigurationXMLFile(updateAutomatically);
    }

    public boolean device_connectWithProfile(StructConfigParameters profile) {
        return device.device_connectWithProfile(profile);
    }

    public void device_ConnectWithoutValidation(boolean noValidate) {
        device.device_ConnectWithoutValidation(noValidate, ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ);
    }

    public boolean device_connect() {
        return device.device_connect();
    }

    public boolean device_isConnected() {
        return device.device_isConnected();
    }

    public int device_startRKI() {
        return device.device_startRKI();
    }

    public int autoConfig_start(String strXMLFilename) {
        return device.autoConfig_start(strXMLFilename);
    }

    public void autoConfig_stop() {
        device.autoConfig_stop();
    }

    public int device_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags) {
        return device.device_startTransaction(amount, amtOther, type, timeout, tags);
    }

    public int device_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags, boolean isFastEMV) {
        return device.device_startTransaction(amount, amtOther, type, timeout, tags, isFastEMV);
    }

    public int device_cancelTransaction() {
        return device.device_cancelTransaction();
    }

    public int device_calibrateParameters(byte delta) {
        return device.device_calibrateParameters(delta);
    }

    public int device_getDriveFreeSpace(StringBuilder freeSpace, StringBuilder usedSpace) {
        return device.device_getDriveFreeSpace(freeSpace, usedSpace);
    }

    public int device_listDirectory(String directoryName, boolean recursive, boolean onSD, StringBuilder directory) {
        return device.device_listDirectory(directoryName, recursive, onSD, directory);
    }

    public int device_createDirectory(String directoryName) {
        return device.device_createDirectory(directoryName);
    }

    public int device_deleteDirectory(String directoryName) {
        return device.device_deleteDirectory(directoryName);
    }

    public int device_deleteFile(String fileName) {
        return device.device_deleteFile(fileName);
    }

    public int device_enhancedPassthrough(byte[] data) {
        return device.device_enhancedPassthrough(data);
    }

    public int device_controlIndicator(byte indicator, boolean enable) {
        return device.device_controlIndicator(indicator, enable);
    }

    public int device_getFirmwareVersion(StringBuilder version) {
        return device.device_getFirmwareVersion(version);
    }

    public int device_pingDevice() {
        return device.device_pingDevice();
    }

    public int device_ReviewAudioJackSetting(ResDataStruct respData) {
        return device.device_ReviewAudioJackSetting(respData);
    }

    public int config_getSerialNumber(StringBuilder serialNumber) {
        return device.config_getSerialNumber(serialNumber);
    }

    public int config_getModelNumber(StringBuilder modNumber) {
        return device.config_getModelNumber(modNumber);
    }

    public int device_getKSN(ResDataStruct ksn) {
        return device.device_getKSN(ksn);
    }

    public int device_setMerchantRecord(int index, boolean enabled, String merchantID, String merchantURL) {
        return device.device_setMerchantRecord(index, enabled, merchantID, merchantURL);
    }

    public int device_getMerchantRecord(int index, ResDataStruct respData) {
        return device.device_getMerchantRecord(index, respData);
    }

    public String device_getResponseCodeString(int errorCode) {
        return ErrorCodeInfo.getErrorCodeDescription(errorCode);
    }

    public int device_sendDataCommand(String cmd, boolean calcLRC, String data, ResDataStruct respData) {
        return device.device_sendDataCommand(cmd, calcLRC, data, respData);
    }

    public int device_sendDataCommand(String cmd, boolean calcLRC, String data, ResDataStruct respData, int timeout) {
        return device.device_sendDataCommand(cmd, calcLRC, data, respData, timeout);
    }

    public int device_updateFirmware(String[] commands) {
        return device.device_updateFirmware(commands);
    }

    public int device_getTransactionResults(IDTMSRData cardData) {
        return device.device_getTransactionResults(cardData);
    }

    public int device_setBurstMode(byte mode) {
        return device.device_setBurstMode(mode);
    }

    public int device_setPollMode(byte mode) {
        return device.device_setPollMode(mode);
    }

    public int device_getRTCDateTime(byte[] dateTime) {
        return device.device_getRTCDateTime(dateTime);
    }

    public int device_setRTCDateTime(byte[] dateTime) {
        return device.device_setRTCDateTime(dateTime);
    }

    public int icc_getICCReaderStatus(ICCReaderStatusStruct ICCStatus) {
        return device.icc_getICCReaderStatus(ICCStatus);
    }

    public int icc_powerOnICC(ResDataStruct atrPPS) {
        return device.icc_powerOnICC(atrPPS);
    }

    public int icc_passthroughOnICC() {
        return device.icc_passthroughOnICC();
    }

    public int icc_passthroughOffICC() {
        return device.icc_passthroughOffICC();
    }

    public int icc_powerOffICC(ResDataStruct respData) {
        return device.icc_powerOffICC(respData);
    }

    public int icc_exchangeAPDU(byte[] dataAPDU, ResDataStruct response) {
        return device.icc_exchangeAPDU(dataAPDU, response);
    }

    public int emv_getEMVKernelVersion(StringBuilder version) {
        return device.emv_getEMVKernelVersion(version);
    }

    public int emv_getEMVKernelCheckValue(ResDataStruct respData) {
        return device.emv_getEMVKernelCheckValue(respData);
    }

    public int emv_getEMVConfigurationCheckValue(ResDataStruct respData) {
        return device.emv_getEMVConfigurationCheckValue(respData);
    }

    public static void emv_allowFallback(boolean allow) {
        IDT_Device.emv_allowFallback(allow);
    }

    public int emv_retrieveApplicationData(String aid, ResDataStruct respData) {
        return device.emv_retrieveApplicationData(aid, respData);
    }

    public int emv_removeApplicationData(String aid, ResDataStruct respData) {
        return device.emv_removeApplicationData(aid, respData);
    }

    public int emv_setApplicationData(String aid, byte[] TLV, ResDataStruct respData) {
        return device.emv_setApplicationData(aid, TLV, respData);
    }

    public int emv_retrieveTerminalData(ResDataStruct respData) {
        return device.emv_retrieveTerminalData(respData);
    }

    public int emv_removeTerminalData(ResDataStruct respData) {
        return device.emv_removeTerminalData(respData);
    }

    public int emv_setTerminalData(byte[] TLV, ResDataStruct respData) {
        return device.emv_setTerminalData(TLV, respData);
    }

    public int emv_retrieveAidList(ResDataStruct respData) {
        return device.emv_retrieveAidList(respData);
    }

    public int emv_retrieveCAPK(byte[] data, ResDataStruct respData) {
        return device.emv_retrieveCAPK(data, respData);
    }

    public int emv_removeCAPK(byte[] capk, ResDataStruct respData) {
        return device.emv_removeCAPK(capk, respData);
    }

    public int emv_setCAPK(byte[] key, ResDataStruct respData) {
        return device.emv_setCAPK(key, respData);
    }

    public static void emv_setAutoAuthenticateTransaction(boolean auto) {
        IDT_Device.emv_setAutoAuthenticateTransaction(auto);
    }

    public static boolean emv_getAutoAuthenticateTransaction() {
        return IDT_Device.emv_getAutoAuthenticateTransaction();
    }

    public static void emv_setAutoCompleteTransaction(boolean auto) {
        IDT_Device.emv_setAutoCompleteTransaction(auto);
    }

    public static boolean emv_getAutoCompleteTransaction() {
        return IDT_Device.emv_getAutoCompleteTransaction();
    }

    public int emv_retrieveCAPKList(ResDataStruct respData) {
        return device.emv_retrieveCAPKList(respData);
    }

    public int emv_retrieveCRL(ResDataStruct respData) {
        return device.emv_retrieveCRL(respData);
    }

    public int emv_removeCRL(byte[] crlList, ResDataStruct respData) {
        return device.emv_removeCRL(crlList, respData);
    }

    public int emv_setCRL(byte[] crlList, ResDataStruct respData) {
        return device.emv_setCRL(crlList, respData);
    }

    public int emv_removeAllCRL() {
        return device.emv_removeAllCRL();
    }

    public int emv_retrieveExceptionList(ResDataStruct respData) {
        return device.emv_retrieveExceptionList(respData);
    }

    public int emv_setException(byte[] exception) {
        return device.emv_setException(exception);
    }

    public int emv_removeException(byte[] exception) {
        return device.emv_removeException(exception);
    }

    public int emv_removeAllExceptions() {
        return device.emv_removeAllExceptions();
    }

    public int emv_retrieveExceptionLogStatus(ResDataStruct respData) {
        return device.emv_retrieveExceptionLogStatus(respData);
    }

    public int emv_retrieveTransactionLogStatus(ResDataStruct respData) {
        return device.emv_retrieveTransactionLogStatus(respData);
    }

    public int emv_retrieveTransactionLog(ResDataStruct respData) {
        return device.emv_retrieveTransactionLog(respData);
    }

    public int emv_removeTransactionLog() {
        return device.emv_removeTransactionLog();
    }

    public int emv_retrieveCRLStatus(ResDataStruct respData) {
        return device.emv_retrieveCRLStatus(respData);
    }

    public int emv_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags, boolean forceOnline) {
        return device.emv_startTransaction(amount, amtOther, type, timeout, tags, forceOnline);
    }

    public int emv_cancelTransaction(ResDataStruct respData) {
        return device.emv_cancelTransaction(respData);
    }

    public void emv_setTransactionParameters(double amount, double amtOther, int type, int timeout, byte[] tags) {
        device.emv_setTransactionParameters(amount, amtOther, type, timeout, tags);
    }

    public void emv_lcdControlResponse(byte mode, byte data) {
        device.emv_lcdControlResponse(mode, data);
    }

    public int emv_authenticateTransaction(byte[] tags) {
        return device.emv_authenticateTransaction(tags);
    }

    public int emv_completeTransaction(boolean commError, byte[] authCode, byte[] iad, byte[] tlvScripts, byte[] tags) {
        return device.emv_completeTransaction(commError, authCode, iad, tlvScripts, tags);
    }

    public int emv_retrieveTransactionResult(byte[] tags, Map<String, Map<String, byte[]>> retrievedTags) {
        return device.emv_retrieveTransactionResult(tags, retrievedTags);
    }

    public int device_reviewAllSetting(ResDataStruct respData) {
        return device.device_reviewAllSetting(respData);
    }

    public int msr_defaultAllSetting() {
        return device.msr_defaultAllSetting();
    }

    public int msr_getSingleSetting(byte funcID, byte[] response) {
        return device.msr_getSingleSetting(funcID, response);
    }

    public int msr_setSingleSetting(byte funcID, byte setData) {
        return device.msr_setSingleSetting(funcID, setData);
    }

    public int msr_cancelMSRSwipe() {
        return device.msr_cancelMSRSwipe();
    }

    public int msr_startMSRSwipe() {
        return device.msr_startMSRSwipe();
    }

    public int msr_startMSRSwipe(int timeout) {
        return device.msr_startMSRSwipe(timeout);
    }

    public int ctls_retrieveApplicationData(String aid, ResDataStruct respData) {
        return device.ctls_retrieveApplicationData(aid, respData);
    }

    public int ctls_removeApplicationData(String aid, ResDataStruct respData) {
        return device.ctls_removeApplicationData(aid, respData);
    }

    public int ctls_setApplicationData(byte[] TLV, ResDataStruct respData) {
        return device.ctls_setApplicationData(TLV, respData);
    }

    public int ctls_setConfigurationGroup(byte[] TLV, ResDataStruct respData) {
        return device.ctls_setConfigurationGroup(TLV, respData);
    }

    public int ctls_getConfigurationGroup(int group, ResDataStruct respData) {
        return device.ctls_getConfigurationGroup(group, respData);
    }

    public int ctls_getAllConfigurationGroups(ResDataStruct respData) {
        return device.ctls_getAllConfigurationGroups(respData);
    }

    public int ctls_removeConfigurationGroup(int group) {
        return device.ctls_removeConfigurationGroup(group);
    }

    public int ctls_retrieveTerminalData(ResDataStruct respData) {
        return device.ctls_retrieveTerminalData(respData);
    }

    public int ctls_setTerminalData(byte[] TLV, ResDataStruct respData) {
        return device.ctls_setTerminalData(TLV, respData);
    }

    public int ctls_retrieveAidList(ResDataStruct respData) {
        return device.ctls_retrieveAidList(respData);
    }

    public int ctls_retrieveCAPK(byte[] data, ResDataStruct respData) {
        return device.ctls_retrieveCAPK(data, respData);
    }

    public int ctls_removeCAPK(byte[] capk, ResDataStruct respData) {
        return device.ctls_removeCAPK(capk, respData);
    }

    public int ctls_setCAPK(byte[] key, ResDataStruct respData) {
        return device.ctls_setCAPK(key, respData);
    }

    public int ctls_retrieveCAPKList(ResDataStruct respData) {
        return device.ctls_retrieveCAPKList(respData);
    }

    public int ctls_removeAllApplicationData() {
        return device.ctls_removeAllApplicationData();
    }

    public int ctls_removeAllCAPK() {
        return device.ctls_removeAllCAPK();
    }

    public int ctls_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags) {
        return device.ctls_startTransaction(amount, amtOther, type, timeout, tags);
    }

    public int ctls_cancelTransaction() {
        return device.ctls_cancelTransaction();
    }

    public int ctls_resetConfigurationGroup(int group) {
        return device.ctls_resetConfigurationGroup(group);
    }

    public int ctls_displayOnlineAuthResult(boolean isOK, byte[] tlv) {
        return device.ctls_displayOnlineAuthResult(isOK, tlv);
    }

    public int pin_getEncryptedOnlinePIN(int keyType, int timeout) {
        return device.pin_getEncryptedOnlinePIN(keyType, timeout);
    }

    public int pin_getPAN(int getCSC, int timeout) {
        return device.pin_getPAN(getCSC, timeout);
    }

    public int pin_promptCreditDebit(byte currencySymbol, String displayAmount, int timeout, ResDataStruct respData) {
        return device.pin_promptCreditDebit(currencySymbol, displayAmount, timeout, respData);
    }

    public int ws_requestCSR(ResDataStruct respData) {
        return device.ws_requestCSR(respData);
    }

    public int ws_loadSSLCert(String name, String dataDER) {
        return device.ws_loadSSLCert(name, dataDER);
    }

    public int ws_revokeSSLCert(String name) {
        return device.ws_revokeSSLCert(name);
    }

    public int ws_deleteSSLCert(String name) {
        return device.ws_deleteSSLCert(name);
    }

    public int ws_getCertChainType(ResDataStruct respData) {
        return device.ws_getCertChainType(respData);
    }

    public int ws_updateRootCertificate(String name, String dataDER, String signature) {
        return device.ws_updateRootCertificate(name, dataDER, signature);
    }

    public int lcd_resetInitialState() {
        return device.lcd_resetInitialState();
    }

    public int lcd_customDisplayMode(boolean enable) {
        return device.lcd_customDisplayMode(enable);
    }

    public int lcd_setForeBackColor(byte[] foreRGB, byte[] backRGB) {
        return device.lcd_setForeBackColor(foreRGB, backRGB);
    }

    public int lcd_clearDisplay() {
        return device.lcd_clearDisplay();
    }

    public int lcd_captureSignature(int timeout) {
        return device.lcd_captureSignature(timeout);
    }

    public int lcd_startSlideShow(String files, int posX, int posY, int posMode, boolean touchEnable, boolean recursion, boolean touchTerminate, int delay, int loops, boolean clearScreen) {
        return device.lcd_startSlideShow(files, posX, posY, posMode, touchEnable, recursion, touchTerminate, delay, loops, clearScreen);
    }

    public int lcd_cancelSlideShow(ResDataStruct respData) {
        return device.lcd_cancelSlideShow(respData);
    }

    public int lcd_setDisplayImage(String files, int posX, int posY, int posMode, boolean touchEnable, boolean clearScreen) {
        return device.lcd_setDisplayImage(files, posX, posY, posMode, touchEnable, clearScreen);
    }

    public int lcd_setBackgroundImage(String files, boolean enable) {
        return device.lcd_setBackgroundImage(files, enable);
    }

    public int lcd_displayText(int posX, int posY, int displayWidth, int displayHeight, int fontDesignation, int fontID, int screenPosition, String displayText, ResDataStruct respData) {
        return device.lcd_displayText(posX, posY, displayWidth, displayHeight, fontDesignation, fontID, screenPosition, displayText, respData);
    }

    public int lcd_displayParagraph(int posX, int posY, int displayWidth, int displayHeight, int fontDesignation, int fontID, int displayProperties, String displayText) {
        return device.lcd_displayParagraph(posX, posY, displayWidth, displayHeight, fontDesignation, fontID, displayProperties, displayText);
    }

    public int lcd_displayButton(int posX, int posY, int buttonWidth, int buttonHeight, int fontDesignation, int fontID, int displayPosition, String buttonLabel, int buttonTextColorR, int buttonTextColorG, int buttonTextColorB, int buttonBackgroundColorR, int buttonBackgroundColorG, int buttonBackgroundColorB, ResDataStruct respData) {
        return device.lcd_displayButton(posX, posY, buttonWidth, buttonHeight, fontDesignation, fontID, displayPosition, buttonLabel, buttonTextColorR, buttonTextColorG, buttonTextColorB, buttonBackgroundColorR, buttonBackgroundColorG, buttonBackgroundColorB, respData);
    }

    public int lcd_createList(int posX, int posY, int numOfColumns, int numOfRows, int fontDesignation, int fontID, boolean verticalScrollArrowsVisible, boolean borderedListItems, boolean borderdScrollArrows, boolean touchSensitive, boolean automaticScrolling, ResDataStruct respData) {
        return device.lcd_createList(posX, posY, numOfColumns, numOfRows, fontDesignation, fontID, verticalScrollArrowsVisible, borderedListItems, borderdScrollArrows, touchSensitive, automaticScrolling, respData);
    }

    public int lcd_addItemToList(byte[] listGraphicsID, String itemName, String itemID, boolean selected) {
        return device.lcd_addItemToList(listGraphicsID, itemName, itemID, selected);
    }

    public int lcd_getSelectedListItem(byte[] listGraphicsID, String itemID, ResDataStruct respData) {
        return device.lcd_getSelectedListItem(listGraphicsID, itemID, respData);
    }

    public int lcd_clearEventQueue() {
        return device.lcd_clearEventQueue();
    }

    public int lcd_getInputEvent(int timeout, ResDataStruct respData) {
        return device.lcd_getInputEvent(timeout, respData);
    }

    public int lcd_createInputField(byte[] specs, ResDataStruct respData) {
        return device.lcd_createInputField(specs, respData);
    }

    public int lcd_getInputFieldValue(byte[] listGraphicsID, ResDataStruct respData) {
        return device.lcd_getInputFieldValue(listGraphicsID, respData);
    }

    public String createFastEMVData(IDTEMVData emvData) {
        return device.createFastEMVData(emvData);
    }
}

