/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.OnReceiverListenerPIN;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.config.UmXmlParser;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.tasks.AutoConfigTask;
import com.idtechproducts.device.audiojack.tasks.CommandSynchroTask;
import com.idtechproducts.device.audiojack.tasks.CommandTask;
import com.idtechproducts.device.audiojack.tasks.ConnectTask;
import com.idtechproducts.device.audiojack.tasks.FwGetChallengeTask;
import com.idtechproducts.device.audiojack.tasks.FwUpdateTask;
import com.idtechproducts.device.audiojack.tasks.FwUpdateTaskUniPay;
import com.idtechproducts.device.audiojack.tasks.ReceiveSynchroTask;
import com.idtechproducts.device.audiojack.tasks.RemoteKeyInjectionTask;
import com.idtechproducts.device.audiojack.tasks.SwipeTask;
import com.idtechproducts.device.audiojack.tasks.SwipeUMTask;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.bluetooth.IDTechBluetoothLE;
import com.idtechproducts.device.rs232.IDTechRS232;
import com.idtechproducts.device.usb.IDTechUsbHid;
import java.util.ArrayList;

public class TaskManager {
    private final OnReceiverListener _umrMsg;
    private final OnReceiverListenerPIN _umrPINMsg;
    private ReaderCommunication _readerCommunication;
    private final Context _context;
    private volatile Task _state_task;
    private volatile Task waitingTask = null;
    private volatile Thread _state_task_thread;
    private double _cfg_waitingMSRResponseTimeout;
    private double _cfg_waitingPINResponseTimeout = 30.0;
    private double _cfg_waitingAPDUResponseTimeout = 5.0;
    private double _cfg_waitingEMVResponseTimeout = 30.0;
    private final double defaultTimeoutSec = 32.0;
    private boolean _cfg_connectReaderWithCommand = true;
    private CommandSynchroTask theCmd;
    private static final String TAG = "SDK::TaskManager";
    private IDT_Device.TaskExport _taskExport;
    private volatile RUNING_TASK runingTask;

    public RUNING_TASK getState_getRunningTask() {
        return this.runingTask;
    }

    public TaskManager(OnReceiverListener umrMsg, Context context, IDT_Device.TaskExport taskExport) {
        this._umrMsg = umrMsg;
        this._umrPINMsg = null;
        this._context = context;
        this._readerCommunication = null;
        this._state_task = null;
        this.waitingTask = null;
        this._state_task_thread = null;
        this._taskExport = taskExport;
        this.runingTask = RUNING_TASK.NONE_TASK;
        this._cfg_waitingMSRResponseTimeout = 32.0;
        this._cfg_connectReaderWithCommand = true;
    }

    public TaskManager(OnReceiverListener umrMsg, OnReceiverListenerPIN umrPINMsg, Context context, IDT_Device.TaskExport taskExport) {
        this._umrMsg = umrMsg;
        this._umrPINMsg = umrPINMsg;
        this._context = context;
        this._readerCommunication = null;
        this._state_task = null;
        this.waitingTask = null;
        this._state_task_thread = null;
        this._taskExport = taskExport;
        this.runingTask = RUNING_TASK.NONE_TASK;
        this._cfg_waitingMSRResponseTimeout = 32.0;
        this._cfg_connectReaderWithCommand = true;
    }

    public void setReaderXommunication(ReaderCommunication readerCommunication) {
        this._readerCommunication = readerCommunication;
    }

    public ReaderCommunication getReaderXommunication() {
        return this._readerCommunication;
    }

    public void release() {
        this._state_task = null;
        this.waitingTask = null;
        this.runingTask = RUNING_TASK.NONE_TASK;
        this._state_task_thread = null;
        this._cfg_waitingMSRResponseTimeout = 32.0;
        this._cfg_connectReaderWithCommand = true;
    }

    public int getRuningTaskCode() {
        switch (this.runingTask) {
            case TASK_MSR: {
                return 5;
            }
            case TASK_PIN: {
                return 6;
            }
            case TASK_EMVL2: {
                return 7;
            }
            case TASK_CONNECT: 
            case TASK_COMMAND: 
            case TASK_AUTO_CONFIG: 
            case TASK_POWER: 
            case TASK_FW_UPDATE: 
            case TASK_RKI: {
                return 19;
            }
        }
        return 0;
    }

    public TaskStartRet task_start_connect() {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        IOManager _ioManager = this._readerCommunication.getIntern_IOManager();
        if (this._readerCommunication.getState_isConnected()) {
            this._readerCommunication.cxn_setDisconnected();
        }
        if (_ioManager != null && !_ioManager.isRecording()) {
            _ioManager.stopRecordThread();
            _ioManager.startRecordThread();
            UMLog.i(TAG, "TaskManager -> task_start_connect");
        }
        this._cfg_connectReaderWithCommand = true;
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            this._cfg_connectReaderWithCommand = false;
        }
        this.task_setAndStart(new ConnectTask(this, this._readerCommunication, this._cfg_connectReaderWithCommand, this._taskExport), RUNING_TASK.TASK_CONNECT);
        this._umrMsg.msgToConnectDevice();
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_connect(Common.PUSType pus) {
        if (pus == null) {
            return this.task_start_connect();
        }
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        IOManager _ioManager = this._readerCommunication.getIntern_IOManager();
        if (this._readerCommunication.getState_isConnected()) {
            this._readerCommunication.cxn_setDisconnected();
        }
        if (_ioManager != null && !_ioManager.isRecording()) {
            _ioManager.stopRecordThread();
            _ioManager.startRecordThread();
            UMLog.i(TAG, "TaskManager -> task_start_connect");
        }
        this._cfg_connectReaderWithCommand = true;
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            this._cfg_connectReaderWithCommand = false;
        }
        this._umrMsg.msgToConnectDevice();
        this.task_setAndStart(new ConnectTask(this, this._readerCommunication, pus), RUNING_TASK.TASK_CONNECT);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_swipe() {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG, TaskStartRet.NOT_CONNECTED);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO) {
            this.task_setAndStart(new SwipeUMTask(this, this._readerCommunication, this._cfg_waitingMSRResponseTimeout), RUNING_TASK.TASK_MSR);
        } else {
            this.task_setAndStart(new SwipeTask(this, this._readerCommunication, this._cfg_waitingMSRResponseTimeout), RUNING_TASK.TASK_MSR);
        }
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_rki(OnReceiverListener _callback, IDTechUsbHid _usb) {
        TaskStartRet chk;
        if (_usb == null && (chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG, TaskStartRet.NOT_CONNECTED)) != TaskStartRet.SUCCESS) {
            return chk;
        }
        IDT_Device.isCommandRunning = true;
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.task_setAndStart(new RemoteKeyInjectionTask(this, this._readerCommunication, _callback, _usb, this._taskExport), RUNING_TASK.TASK_RKI);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_rki(OnReceiverListener _callback, IDTechRS232 _com) {
        TaskStartRet chk;
        if (_com == null && (chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG, TaskStartRet.NOT_CONNECTED)) != TaskStartRet.SUCCESS) {
            return chk;
        }
        IDT_Device.isCommandRunning = true;
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.task_setAndStart(new RemoteKeyInjectionTask(this, this._readerCommunication, _callback, _com, this._taskExport), RUNING_TASK.TASK_RKI);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_rki(OnReceiverListener _callback, IDTechBluetoothLE _btle) {
        IDT_Device.isCommandRunning = true;
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.task_setAndStart(new RemoteKeyInjectionTask(this, this._readerCommunication, _callback, _btle, this._taskExport), RUNING_TASK.TASK_RKI);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_command(byte[] command, int commandID) {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG, TaskStartRet.NOT_CONNECTED);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        this.task_setAndStart(new CommandTask(this, this._readerCommunication, command, commandID), RUNING_TASK.TASK_COMMAND);
        return TaskStartRet.SUCCESS;
    }

    public void cancelCurrentCommand() {
        if (this.theCmd != null) {
            this.theCmd.cancel();
        }
    }

    public TaskStartRet task_start_command_synchro(byte[] command, ResDataStruct respData) {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        byte[] logCommand = command;
        if (command != null) {
            int i = 0;
            while (i < command.length) {
                if (command[i] != 85) break;
                ++i;
            }
            if (command.length - i > 0) {
                logCommand = new byte[command.length - i];
                System.arraycopy(command, i, logCommand, 0, logCommand.length);
            }
        }
        UMLog.i("**sendCommand**", command == null ? "null" : (logCommand == null ? "null" : Common.base16Encode(logCommand)));
        this.theCmd = new CommandSynchroTask(this, this._readerCommunication, command);
        this.theCmd.getResponse(respData);
        UMLog.i("**getResponse**", "okay");
        this._umrMsg.dataInOutMonitor(respData.resData, true);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_command_send_only_synchro(byte[] command) {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        byte[] logCommand = command;
        if (command != null) {
            int i = 0;
            while (i < command.length) {
                if (command[i] != 85) break;
                ++i;
            }
            if (command.length - i > 0) {
                logCommand = new byte[command.length - i];
                System.arraycopy(command, i, logCommand, 0, logCommand.length);
            }
        }
        UMLog.i("**sendCommand**", command == null ? "null" : (logCommand == null ? "null" : Common.base16Encode(logCommand)));
        this.theCmd = new CommandSynchroTask(this, this._readerCommunication, command);
        this.theCmd.getResponse(null);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_command_for_fw(byte[] command, ResDataStruct respData) {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.NO_CONFIG, TaskStartRet.NOT_CONNECTED);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        CommandSynchroTask cmd = new CommandSynchroTask(this, this._readerCommunication, command);
        cmd.getResponse(respData);
        UMLog.i("**getResponse**", "okay");
        this._umrMsg.dataInOutMonitor(respData.resData, true);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_receive_synchro(ResDataStruct respData, boolean checkMuliAPDU, IDT_Device device, boolean isReadRecord, IDTechUsbHid usb) {
        ReceiveSynchroTask cmd = null;
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG, TaskStartRet.NOT_CONNECTED);
            if (chk != TaskStartRet.SUCCESS) {
                return chk;
            }
            cmd = new ReceiveSynchroTask(this, this._readerCommunication, this._cfg_waitingMSRResponseTimeout);
            cmd.getResponse(respData);
            this._umrMsg.dataInOutMonitor(respData.resData, true);
        } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            usb.readBuffer(respData);
        } else {
            return TaskStartRet.NOT_SUPPORTED;
        }
        checkMuliAPDU = true;
        if (true) {
            byte[] packetData;
            ArrayList<byte[]> respPacket = new ArrayList<byte[]>();
            boolean packetFinished = false;
            int countRPDU = 0;
            int totalLen = 0;
            long waitTime = 60L;
            long timeLimit = waitTime * 1000L;
            long timeBegin = System.currentTimeMillis();
            do {
                byte[] packet;
                if (respData.resData == null) {
                    if (this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    usb.readBuffer(respData);
                    continue;
                }
                if (respData.resData == null || respData.resData.length <= 9 || respData.resData[3] != 6 || respData.resData[4] != -95) continue;
                if (respData.resData[5] == 0) {
                    packetFinished = true;
                    countRPDU += respData.resData[6];
                    int paketLen = respData.resData.length - 10;
                    packet = new byte[paketLen];
                    System.arraycopy(respData.resData, 7, packet, 0, paketLen);
                    totalLen += paketLen;
                    respPacket.add(packet);
                    break;
                }
                if (respData.resData[5] != 1) continue;
                countRPDU += respData.resData[6];
                int paketLen = respData.resData.length - 10;
                packet = new byte[paketLen];
                System.arraycopy(respData.resData, 7, packet, 0, paketLen);
                byte[] temp = new byte[1000];
                int tempSize = 0;
                int x = 0;
                while (x < paketLen) {
                    int len = (packet[x] & 0xFF) + (packet[x + 1] & 0xFF) * 256;
                    temp[tempSize++] = (byte)(len + 1 & 0xFF);
                    temp[tempSize++] = (byte)(len + 1 >> 8 & 0xFF);
                    temp[tempSize++] = 0;
                    x += 2;
                    if (isReadRecord) {
                        byte[] updatedPacket = new byte[len];
                        System.arraycopy(packet, x, updatedPacket, 0, len);
                        UMLog.i("EMV_KERNEL", "Updated Packet 01 = " + Common.getHexStringFromBytes(updatedPacket));
                        byte[] newPacket = device.parseR_APDU(updatedPacket);
                        UMLog.i("EMV_KERNEL", "New Packet 01 = " + Common.getHexStringFromBytes(newPacket));
                        int newlen = newPacket.length;
                        temp[tempSize - 3] = (byte)(newlen + 1 & 0xFF);
                        temp[tempSize - 2] = (byte)(newlen + 1 >> 8 & 0xFF);
                        System.arraycopy(newPacket, 0, temp, tempSize, newlen);
                        tempSize += newlen;
                    } else {
                        System.arraycopy(packet, x, temp, tempSize, len);
                        tempSize += len;
                    }
                    x += len;
                    ++x;
                }
                paketLen = tempSize;
                packet = new byte[paketLen];
                System.arraycopy(temp, 0, packet, 0, paketLen);
                totalLen += paketLen;
                respPacket.add(packet);
                if (System.currentTimeMillis() - timeBegin >= timeLimit) break;
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
                    cmd.getResponse(respData);
                    continue;
                }
                if (this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                usb.readBuffer(respData);
            } while (!packetFinished);
            if (packetFinished) {
                packetData = new byte[totalLen + 1];
                packetData[0] = (byte)countRPDU;
                int sum = 1;
                int i = 0;
                while (i < respPacket.size()) {
                    byte[] temp = (byte[])respPacket.get(i);
                    System.arraycopy(temp, 0, packetData, sum, temp.length);
                    sum += temp.length;
                    ++i;
                }
            } else {
                return TaskStartRet.NO_RESPONSE;
            }
            respData.resData = packetData;
            respPacket.clear();
            respPacket.trimToSize();
            respPacket = null;
        }
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_fwGetChallenge(FirmwareUpdateToolMsg umtMsg) {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        this.task_setAndStart(new FwGetChallengeTask(this, this._readerCommunication, umtMsg), RUNING_TASK.TASK_COMMAND);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_fwUpdate(FirmwareUpdateToolMsg umtMsg, FirmwareUpdateTool.FMStruct fmFile) {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        this.task_setAndStart(new FwUpdateTaskUniPay(this, this._readerCommunication, this._taskExport.getConfig(), umtMsg, fmFile), RUNING_TASK.TASK_FW_UPDATE);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_fwUpdate(FirmwareUpdateToolMsg umtMsg, boolean isEncryptedUpdate, byte[] binFile, byte[] challengeResponse) {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NO_CONFIG);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        this.task_setAndStart(new FwUpdateTask(this, this._readerCommunication, umtMsg, isEncryptedUpdate, binFile, challengeResponse), RUNING_TASK.TASK_FW_UPDATE);
        return TaskStartRet.SUCCESS;
    }

    public TaskStartRet task_start_autoConfig(String strXMLFilename) {
        TaskStartRet chk = this.task_checkStatusAndWarn(TaskStartRet.NO_READER, TaskStartRet.SDK_BUSY, TaskStartRet.NOT_SUPPORTED);
        if (chk != TaskStartRet.SUCCESS) {
            return chk;
        }
        ArrayList<StructConfigParameters> templates = null;
        if (strXMLFilename != null) {
            UmXmlParser.UMXmlParseResult parseResult = UmXmlParser.parseFile(strXMLFilename, null, null, true);
            if (parseResult.fileExists) {
                if (parseResult.templates != null) {
                    templates = parseResult.templates;
                } else {
                    UMLog.w(TAG, "AutoConfig: templates not loaded: file parsing failed");
                }
            } else {
                UMLog.w(TAG, "AutoConfig: templates not loaded: cannot open file");
            }
        } else {
            templates = new ArrayList();
            StructConfigParameters struct = new StructConfigParameters();
            struct.setFrequenceOutput(48000);
            struct.setFrequenceInput(48000);
            struct.setBaudRate(9600);
            struct.setVolumeLevelAdjust((short)1);
            struct.setModelNumber("48K 48K 9600");
            if (Common.checkFrequencySupported(48000, 48000)) {
                templates.add(struct);
            }
            struct = new StructConfigParameters();
            struct.setFrequenceOutput(48000);
            struct.setFrequenceInput(48000);
            struct.setBaudRate(4800);
            struct.setModelNumber("48K 48K 4800");
            if (Common.checkFrequencySupported(48000, 48000)) {
                templates.add(struct);
            }
            struct = new StructConfigParameters();
            struct.setFrequenceOutput(48000);
            struct.setFrequenceInput(44100);
            struct.setBaudRate(9600);
            struct.setModelNumber("44.1K 48K 9600");
            if (Common.checkFrequencySupported(44100, 48000)) {
                templates.add(struct);
            }
            struct = new StructConfigParameters();
            struct.setFrequenceOutput(48000);
            struct.setFrequenceInput(32000);
            struct.setBaudRate(4800);
            struct.setModelNumber("48K 32K 4800");
            if (Common.checkFrequencySupported(32000, 48000)) {
                templates.add(struct);
            }
            struct = new StructConfigParameters();
            struct.setFrequenceOutput(48000);
            struct.setFrequenceInput(24000);
            struct.setBaudRate(2400);
            struct.setModelNumber("48K 24K 2400");
            if (Common.checkFrequencySupported(24000, 48000)) {
                templates.add(struct);
            }
            struct = new StructConfigParameters();
            struct.setFrequenceOutput(48000);
            struct.setFrequenceInput(16000);
            struct.setBaudRate(2400);
            struct.setModelNumber("48K 16K 2400");
            if (Common.checkFrequencySupported(16000, 48000)) {
                templates.add(struct);
            }
            struct = new StructConfigParameters();
            struct.setFrequenceOutput(48000);
            struct.setFrequenceInput(48000);
            struct.setBaudRate(4800);
            struct.setVolumeLevelAdjust((short)2);
            struct.setModelNumber("48K 48K 4800 vol:-2");
            if (Common.checkFrequencySupported(48000, 48000)) {
                templates.add(struct);
            }
            struct = new StructConfigParameters();
            struct.setFrequenceOutput(48000);
            struct.setFrequenceInput(48000);
            struct.setBaudRate(4800);
            struct.setShuttleChannel((byte)0);
            struct.setModelNumber("48K 48K 4800 output:n");
            if (Common.checkFrequencySupported(48000, 48000)) {
                templates.add(struct);
            }
            struct = new StructConfigParameters();
            struct.setFrequenceOutput(48000);
            struct.setFrequenceInput(11025);
            struct.setBaudRate(2400);
            struct.setUseVoiceRecognition((short)1);
            struct.setModelNumber("48K 11K 2400");
            if (Common.checkFrequencySupported(11025, 48000)) {
                templates.add(struct);
            }
        }
        if (this._readerCommunication.getState_isConnected()) {
            this._readerCommunication.cxn_setDisconnected();
        }
        this.task_setAndStart(new AutoConfigTask(this, this._readerCommunication, this._cfg_connectReaderWithCommand, templates, this._taskExport), RUNING_TASK.TASK_AUTO_CONFIG);
        return TaskStartRet.SUCCESS;
    }

    private TaskStartRet task_checkStatusAndWarn(TaskStartRet ... thingsToCheck) {
        TaskStartRet[] taskStartRetArray = thingsToCheck;
        int n = thingsToCheck.length;
        int n2 = 0;
        while (n2 < n) {
            TaskStartRet thing = taskStartRetArray[n2];
            switch (thing) {
                case NO_READER: {
                    if (this._readerCommunication != null && this._readerCommunication.getState_isAttached()) break;
                    UMLog.w(TAG, "Task not started: Reader not attached");
                    return thing;
                }
                case SDK_BUSY: {
                    if (this._state_task == null) break;
                    UMLog.w(TAG, "Task not started: SDK busy");
                    return thing;
                }
                case NO_CONFIG: {
                    if (this._readerCommunication.getIntern_StructConfigParameters() != null) break;
                    UMLog.w(TAG, "Task not started: SDK config not loaded");
                    return thing;
                }
                case NOT_CONNECTED: {
                    if (this._readerCommunication.getState_isConnected()) break;
                    UMLog.w(TAG, "Task not started: SDK connection state is disconnected");
                    return thing;
                }
                case NOT_SUPPORTED: {
                    if (this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) break;
                    UMLog.w(TAG, "Task not started: SDK connection state is disconnected");
                    return thing;
                }
                case SUCCESS: {
                    throw new IllegalArgumentException();
                }
            }
            ++n2;
        }
        return TaskStartRet.SUCCESS;
    }

    private void task_setAndStart(Task task, RUNING_TASK _runningTask) {
        this._state_task = task;
        this.runingTask = _runningTask;
        this._state_task_thread = new Thread(task);
        this._state_task_thread.setName("UMTask_" + this._state_task.getType().toString());
        this._state_task_thread.start();
    }

    public void task_stop() {
        UMLog.i("===task_stop=====", "====  1 ====");
        if (this._state_task == null) {
            IDT_Device.isCommandRunning = false;
            return;
        }
        UMLog.i("===task_stop=====", "====  2 ====");
        if (this._state_task != null) {
            this._state_task.cancel();
        }
        UMLog.i("===task_stop=====", "====  3 ====");
        if (this._state_task_thread != null) {
            while (this._state_task_thread != null && this._state_task_thread.isAlive()) {
                try {
                    this._state_task_thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        UMLog.i("===task_stop=====", "====  4 ====");
        this._state_task = null;
        this.runingTask = RUNING_TASK.NONE_TASK;
        this._state_task_thread = null;
    }

    public void task_signalStoppedStatus() {
        Handler h = new Handler(Looper.getMainLooper());
        h.post(new Runnable(){

            public void run() {
                TaskManager.this._state_task = null;
                TaskManager.this.runingTask = RUNING_TASK.NONE_TASK;
                TaskManager.this._state_task_thread = null;
            }
        });
    }

    public boolean setWaitingResponseTimeout(int type, double seconds) {
        switch (type) {
            case 0: {
                if (!(seconds >= 5.0) || !(seconds <= 3600.0)) break;
                this._cfg_waitingMSRResponseTimeout = seconds;
                return true;
            }
            case 1: {
                if (!(seconds >= 30.0) || !(seconds <= 60.0)) break;
                this._cfg_waitingPINResponseTimeout = seconds;
                return true;
            }
            case 2: {
                if (!(seconds > 4.0) || !(seconds <= 10.0)) break;
                this._cfg_waitingAPDUResponseTimeout = seconds;
                return true;
            }
            case 3: {
                this._cfg_waitingEMVResponseTimeout = seconds;
                return true;
            }
        }
        return false;
    }

    public void setCfg_connectReaderWithCommand(boolean connectReaderWithCommand) {
        this._cfg_connectReaderWithCommand = connectReaderWithCommand;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RUNING_TASK {
        NONE_TASK,
        TASK_MSR,
        TASK_PIN,
        TASK_EMVL2,
        TASK_CONNECT,
        TASK_COMMAND,
        TASK_AUTO_CONFIG,
        TASK_POWER,
        TASK_FW_UPDATE,
        TASK_RKI;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskStartRet {
        SUCCESS,
        NO_READER,
        SDK_BUSY,
        NO_CONFIG,
        NOT_CONNECTED,
        NOT_SUPPORTED,
        NO_RESPONSE,
        BLE_CMD_OVERFLOW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskType {
        Connect,
        Swipe,
        Command,
        FwUpdate,
        RemoteKeyInjection,
        AutoConfig,
        EMVL2;

    }
}

