/*
 * Decompiled with CFR 0.152.
 */
package com.zeamster.paymentsdk.transaction;

import android.app.Activity;
import android.util.Log;
import com.idtechproducts.device.IDT_VP3300;
import com.idtechproducts.device.ReaderInfo;
import com.zeamster.paymentsdk.resthandler.HttpMethod;
import com.zeamster.paymentsdk.resthandler.ICallback;
import com.zeamster.paymentsdk.resthandler.RestServiceClient;
import com.zeamster.paymentsdk.service.IDTECHBLEService;
import com.zeamster.paymentsdk.service.PaymentMethod;
import com.zeamster.paymentsdk.transaction.EncryptionFormat;
import com.zeamster.paymentsdk.transaction.EntryModeId;
import com.zeamster.paymentsdk.transaction.ICallbackEMV;
import com.zeamster.paymentsdk.transaction.ICallbackTransaction;
import com.zeamster.paymentsdk.transaction.Transaction;
import com.zeamster.paymentsdk.transaction.TransactionAction;
import java.util.HashMap;
import org.json.JSONObject;

public class EMVTransaction
extends Transaction
implements ICallback,
ICallbackTransaction {
    private static final String PAYMENT_METHOD = "payment_method";
    private static final String ACTION = "action";
    private static final String E_FORMAT = "e_format";
    private static final String ENTRY_MODE_ID = "entry_mode_id";
    private static final String E_TRACK_DATA = "e_track_data";
    private static final String EMV_REQUEST = "emv_request";
    private static final String E_SERIAL_NUMBER = "e_serial_number";
    private static final String DEVICE_MANUFACTURER = "DF7906313230303338";
    private static final String DEVICE_SERIAL_NUMBER = "device_serial_number";
    private static final String KERNEL_VERSION = "kernel_version";
    private static final String ACTION_SALE = "sale";
    private static final String FALLBACK_TYPE = "fallback_type";
    private static final String NOAID = "no_aid";
    private static final String TECHNICAL = "technical";
    private ICallback initCallback;
    private IDTECHBLEService idTechBLEService;
    private TransactionAction transactionAction;
    private HashMap<String, Object> payload;

    public boolean isPluginRequest() {
        return this.idTechBLEService.isPluginRequest();
    }

    public void isPluginRequest(boolean pluginRequest) {
        this.idTechBLEService.isPluginRequest(pluginRequest);
    }

    public IDTECHBLEService getIdTechBLEService() {
        return this.idTechBLEService;
    }

    public ReaderInfo.DEVICE_TYPE getDeviceType() {
        return this.idTechBLEService.getDeviceType();
    }

    public void setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        this.idTechBLEService.setDeviceType(deviceType);
    }

    public IDT_VP3300 getIdt_vp3300() {
        return this.idTechBLEService.getIdt_vp3300();
    }

    public EMVTransaction(RestServiceClient restServiceClient, ICallbackEMV callbackEMV, Activity context, ReaderInfo.DEVICE_TYPE deviceType) {
        super(restServiceClient);
        this.idTechBLEService = new IDTECHBLEService(callbackEMV, context, deviceType);
    }

    public void scanForDevices() {
        this.scanForDevices(0L);
    }

    public void scanForDevices(long timeout) {
        this.scanForDevices("00:1C:97", timeout);
    }

    public void scanForDevices(String searchString, long timeout) {
        Log.d((String)"PaymentSDK", (String)"EMVTransaction.scanForDevices");
        this.idTechBLEService.scanForDevices(searchString, timeout);
    }

    public void stopScanForDevices() {
        Log.d((String)"PaymentSDK", (String)"EMVTransaction.stopScanForDevices");
        this.idTechBLEService.stopScanForDevices();
    }

    public boolean connectDeviceByName(String deviceName) {
        Log.d((String)"PaymentSDK", (String)"EMVTransaction.connectDeviceByName");
        return this.idTechBLEService.connectDeviceByName(deviceName);
    }

    public boolean connectDeviceByAddress(String address) {
        Log.d((String)"PaymentSDK", (String)"EMVTransaction.connectDeviceByAddress");
        return this.idTechBLEService.connectDeviceByAddress(address);
    }

    public boolean disconnectDevice() {
        Log.d((String)"PaymentSDK", (String)"EMVTransaction.disconnectDevice");
        return this.idTechBLEService.disconnectDevice();
    }

    public boolean setTimeouts(int idleMinutes, int sleepMinutes) {
        String timeoutLength = "";
        switch (idleMinutes) {
            case 0: {
                timeoutLength = timeoutLength + "0000";
                break;
            }
            case 1: {
                timeoutLength = "0X3C";
                break;
            }
            case 5: {
                timeoutLength = "012C";
                break;
            }
            case 10: {
                timeoutLength = "0258";
                break;
            }
            case 15: {
                timeoutLength = "0384";
                break;
            }
            case 20: {
                timeoutLength = "04B0";
                break;
            }
            case 25: {
                timeoutLength = "05DC";
                break;
            }
            case 30: {
                timeoutLength = "0708";
                break;
            }
            default: {
                return false;
            }
        }
        switch (sleepMinutes) {
            case 0: {
                timeoutLength = timeoutLength + "0000";
                break;
            }
            case 1: {
                timeoutLength = timeoutLength + "0X3C";
                break;
            }
            case 5: {
                timeoutLength = timeoutLength + "012C";
                break;
            }
            case 10: {
                timeoutLength = timeoutLength + "0258";
                break;
            }
            case 15: {
                timeoutLength = timeoutLength + "0384";
                break;
            }
            case 20: {
                timeoutLength = "04B0";
                break;
            }
            case 25: {
                timeoutLength = "05DC";
                break;
            }
            case 30: {
                timeoutLength = timeoutLength + "0708";
                break;
            }
            default: {
                return false;
            }
        }
        this.idTechBLEService.setTimeouts(timeoutLength);
        return true;
    }

    public void performEMVSale(TransactionAction transactionAction, HashMap<String, Object> payload) {
        this.idTechBLEService.setCallbackTransaction(this);
        this.transactionAction = transactionAction;
        double amount = 0.0;
        if (transactionAction == TransactionAction.REFUND) {
            this.idTechBLEService.isRefund = true;
            if (payload.containsKey(ACTION)) {
                payload.remove(ACTION);
            }
            payload.put(ACTION, TransactionAction.REFUND.name().toLowerCase());
        } else {
            this.idTechBLEService.isRefund = false;
        }
        this.payload = payload;
        if (payload.containsKey("transaction_amount")) {
            amount = Double.parseDouble(payload.get("transaction_amount").toString());
        }
        Log.d((String)"PaymentSDK", (String)"EMVTransaction.performEMVSale");
        this.idTechBLEService.startEMVTransaction(amount);
    }

    public void cancelEMVSale() {
        Log.d((String)"PaymentSDK", (String)"EMVTransaction.cancelEMVSale");
        this.idTechBLEService.cancelEMVTransaction();
    }

    public void performRefund(HashMap<String, Object> payload) {
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(payload));
        this.perform(HttpMethod.POST);
    }

    public void performAuthOnly(HashMap<String, Object> payload) {
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(payload));
        this.perform(HttpMethod.POST);
    }

    public void performAVSOnly(HashMap<String, Object> payload) {
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(payload));
        this.perform(HttpMethod.POST);
    }

    @Override
    public void call(Object type, Object data, Object ksn, Object serial, Object kernelVersion, Object isFallback) {
        Log.d((String)"PaymentSDK", (String)"EMVTransaction.call");
        if (type != null && type.toString().equalsIgnoreCase("MSR")) {
            this.payload.remove(EMV_REQUEST);
            this.payload.put(E_FORMAT, EncryptionFormat.IDTECH.toString().toLowerCase());
            if (((Boolean)isFallback).booleanValue()) {
                this.payload.put(ENTRY_MODE_ID, EntryModeId.Fallback.getName());
                if (this.idTechBLEService.isNonTechnicalFallback) {
                    this.payload.put(FALLBACK_TYPE, NOAID);
                } else {
                    this.payload.put(FALLBACK_TYPE, TECHNICAL);
                }
            } else {
                this.payload.put(ENTRY_MODE_ID, EntryModeId.Swiped.getName());
            }
            this.payload.put(E_TRACK_DATA, data.toString());
        } else if (type != null && (type.toString().equalsIgnoreCase("EMVChip") || type.toString().equalsIgnoreCase("EMVTap"))) {
            this.payload.remove(E_TRACK_DATA);
            this.payload.put(E_FORMAT, EncryptionFormat.IDTECH_EMV.toString().toLowerCase());
            if (type.toString().equalsIgnoreCase("EMVTap")) {
                this.payload.put(ENTRY_MODE_ID, EntryModeId.TapCardRead.getName());
            } else {
                this.payload.put(ENTRY_MODE_ID, EntryModeId.ChipCardRead.getName());
            }
            this.payload.put(EMV_REQUEST, data.toString());
            this.payload.put(E_SERIAL_NUMBER, ksn.toString());
        }
        if (!this.payload.containsKey(PAYMENT_METHOD)) {
            this.payload.put(PAYMENT_METHOD, PaymentMethod.CC.name().toLowerCase());
        }
        if (!this.payload.containsKey(ACTION)) {
            this.payload.put(ACTION, TransactionAction.SALE.name().toLowerCase());
        }
        this.payload.put(DEVICE_SERIAL_NUMBER, serial.toString());
        this.payload.put(KERNEL_VERSION, kernelVersion.toString());
        this.restServiceClient.setRequestBody(this.convertToTransactionPayload(this.payload));
        this.perform(HttpMethod.POST);
    }

    public void runInitialDeviceSetup() {
        this.initCallback = this.restServiceClient.getCallback();
        this.restServiceClient.setCallback(this);
        HashMap<String, Object> deviceSettings = this.idTechBLEService.getDeviceSettings();
        this.restServiceClient.setRequestBody(deviceSettings);
        this.perform(HttpMethod.POST);
    }

    public void clearLog() {
        this.idTechBLEService.clearLog();
    }

    @Override
    public void onSuccess(String result) {
        block6: {
            Log.d((String)"PaymentSDK", (String)"EMVTransaction.onSuccess");
            if (result.contains("general_configuration")) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    if (jsonObject.has("general_configuration") && jsonObject.getJSONObject("general_configuration").has("terminal_ics_type")) {
                        this.idTechBLEService.runInitialSetup(jsonObject);
                        this.initCallback.onSuccess("Device Initialized");
                        break block6;
                    }
                    this.initCallback.onSuccess(result);
                }
                catch (Exception ex) {
                    this.initCallback.onSuccess(result);
                }
            } else {
                if (this.isPluginRequest()) {
                    result = "transactionResponse!@#$" + result;
                }
                this.initCallback.onSuccess(result);
            }
        }
    }

    @Override
    public void onFailure(String result) {
        Log.d((String)"PaymentSDK", (String)"EMVTransaction.onFailure");
        if (this.isPluginRequest()) {
            result = "transactionResponse!@#$" + result;
        }
        this.initCallback.onFailure(result);
    }
}

