/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tools;

import android.content.Context;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.rs232.IDTechRS232;
import com.idtechproducts.device.usb.IDTechUsbHid;
import java.lang.reflect.Field;

public class FirmwareUpdateTool {
    private final FirmwareUpdateToolMsg a;
    private IDT_Device b = null;
    private TaskManager c = null;
    private IDTechUsbHid d = null;
    private IDTechRS232 e = null;
    private IDT_Device.TaskExport f = null;
    private FMStruct g = null;

    public FirmwareUpdateTool(FirmwareUpdateToolMsg firmwareUpdateToolMsg, Context context) {
        if (firmwareUpdateToolMsg == null) {
            throw new NullPointerException("argument must not be null");
        }
        this.a = firmwareUpdateToolMsg;
    }

    public void setIDT_Device(IDT_Device iDT_Device) {
        this.b = iDT_Device;
        this.c = null;
        Field[] fieldArray = iDT_Device.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            Field field = fieldArray[n2];
            if (field.getType().equals(TaskManager.class)) {
                try {
                    bl = field.isAccessible();
                    field.setAccessible(true);
                    this.c = (TaskManager)field.get(iDT_Device);
                    field.setAccessible(bl);
                    if (this.d != null && this.f != null) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            } else if (field.getType().equals(IDTechUsbHid.class)) {
                try {
                    bl = field.isAccessible();
                    field.setAccessible(true);
                    this.d = (IDTechUsbHid)field.get(iDT_Device);
                    field.setAccessible(bl);
                    if (this.c != null && this.f != null) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            } else if (field.getType().equals(IDTechRS232.class)) {
                try {
                    bl = field.isAccessible();
                    field.setAccessible(true);
                    this.e = (IDTechRS232)field.get(iDT_Device);
                    field.setAccessible(bl);
                    if (this.c != null && this.f != null) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            } else if (field.getType().equals(IDT_Device.TaskExport.class)) {
                try {
                    field.isAccessible();
                    field.setAccessible(true);
                    this.f = (IDT_Device.TaskExport)field.get(iDT_Device);
                    if (this.c != null && this.d != null) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n2;
        }
    }

    public void setFmFile(String[] stringArray) {
        this.g = new FMStruct(this, stringArray);
    }

    public boolean updateFirmware() {
        if (this.g == null) {
            return false;
        }
        if (!this.b.device_isConnected()) {
            return false;
        }
        if (this.f == null) {
            return false;
        }
        if (this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            TaskManager.TaskStartRet taskStartRet = this.c.task_start_fwUpdate(this.a, this.g);
            return taskStartRet == TaskManager.TaskStartRet.SUCCESS;
        }
        if (this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_PIP_READER || this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
            return this.d.updateFirmware(this.a, this.g);
        }
        if (this.f.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_COM) {
            return this.e.updateFirmware(this.a, this.g);
        }
        return false;
    }

    public class FMStruct {
        public int N = 0;
        public byte[] blockS;
        private byte[] a;
        public byte[] blockN;
        private byte[][] b;
        public String[] commands;

        public FMStruct(FirmwareUpdateTool firmwareUpdateTool, byte[] byArray) {
            this.blockS = new byte[64];
            System.arraycopy(byArray, 0, this.blockS, 0, 64);
            this.a = new byte[256];
            System.arraycopy(byArray, 64, this.a, 0, 256);
            this.blockN = new byte[256];
            System.arraycopy(byArray, byArray.length - 256, this.blockN, 0, 256);
            this.N = (byArray.length - 64 - 256 - 256) / 2304;
            System.out.println("N: " + this.N);
            this.b = new byte[this.N][2304];
            int n = 0;
            while (n < this.N) {
                System.arraycopy(byArray, n * 2304 + 320, this.b[n], 0, 2304);
                ++n;
            }
        }

        public FMStruct(FirmwareUpdateTool firmwareUpdateTool, String[] stringArray) {
            this.commands = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.commands[n] = new String(stringArray[n]);
                ++n;
            }
        }

        public byte[] getBlock(int n) {
            if (n < 0) {
                return null;
            }
            if (n == 0) {
                return this.a;
            }
            return this.b[n - 1];
        }
    }
}

