/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.rs232;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.util.Log;
import android_serialport_api.SerialPort;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.rs232.IDTechRS232Msg;
import com.idtechproducts.device.rs232.RS232ControllerMsg;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class RS232Controller {
    private static final String TAG = "SDK::RS232 Controller";
    public static boolean libRS232Avail = true;
    private final String _name;
    private final String _baudrate;
    private final int _flags;
    private PendingIntent pi;
    private SerialPort mSerialPort = null;
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private Context ctx = null;
    private IDTechRS232Msg _msg = null;
    private RS232ControllerMsg _comMsg = null;
    private IntentFilter mComFilter = null;
    private CheckDeviceThread checkThread;
    private boolean waitingForResult = false;
    private boolean waitingForBulkTransfer = false;
    private boolean toClose = false;
    private int swipeTimeoutSec;
    private int swipeCount = 0;
    private SwipeDataReceiver swipeThread;
    private listenForDataOnThread listenThread = null;
    private byte[] swipeBuffer;
    private byte[] temp;
    private Handler mainHandler = null;
    Runnable deviceAttached = new Runnable(){

        public void run() {
            UMLog.i(RS232Controller.TAG, "Sending attached for device_filter");
            RS232Controller.this._comMsg.onDeviceAttached();
        }
    };
    private static boolean _inThreadLoop = false;
    private boolean registered = false;
    public static int preSendDelay = 0;
    public static int postSendDelay = 0;
    private BroadcastReceiver mComReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
        }
    };

    public void externalConnect() {
        if (IDT_Device.getUSBBypass() && this._comMsg != null) {
            IDT_Device.allowReceiverCallback = true;
            this._comMsg.onDeviceAttached();
        }
    }

    public void externalDisconnect() {
        if (IDT_Device.getUSBBypass() && this._comMsg != null) {
            this._comMsg.onDeviceDetached();
        }
    }

    public void externalDeviceNotFound() {
        if (IDT_Device.getUSBBypass() && this._comMsg != null) {
            this._comMsg.onDeviceNotFound();
        }
    }

    public RS232Controller(Context context, IDTechRS232Msg msg, RS232ControllerMsg msg2, String name, String baudrate, int flags) {
        this.ctx = context;
        this._name = name;
        this._baudrate = baudrate;
        this._flags = flags;
        this._msg = msg;
        this._comMsg = msg2;
        this.swipeBuffer = new byte[4096];
        this.temp = new byte[4096];
        this.swipeTimeoutSec = 200;
        this.mainHandler = new Handler(context.getMainLooper());
    }

    public boolean init() {
        if (this.findRS232Device()) {
            UMLog.i(TAG, "RS232 device is found.");
            return true;
        }
        UMLog.i(TAG, "RS232 device is not found.");
        this._comMsg.onDeviceNotFound();
        return false;
    }

    public boolean initWithThread() {
        if (_inThreadLoop) {
            return false;
        }
        _inThreadLoop = true;
        if (this.findRS232Device()) {
            UMLog.i(TAG, "RS232 device is found.");
            UMLog.i(TAG, "Sending attached for device_filter");
            this.mainHandler.post(this.deviceAttached);
            _inThreadLoop = false;
            return true;
        }
        _inThreadLoop = false;
        return false;
    }

    public void startCheckingConnection() {
        if (IDT_Device.getUSBBypass()) {
            return;
        }
        UMLog.i(TAG, "SDK starts monitoring if reader is connected.");
        this.checkThread = new CheckDeviceThread();
        this.checkThread.start();
    }

    public boolean isRegistered() {
        if (IDT_Device.getUSBBypass()) {
            return true;
        }
        return this.registered;
    }

    public void registerReceiver() {
        this.registered = true;
    }

    public void unregisterReceiver() {
        if (IDT_Device.getUSBBypass()) {
            this.registered = false;
            return;
        }
        UMLog.i(TAG, "A Broadcast receiver unregistered.");
        this.close();
        this.mComFilter = null;
        this.registered = false;
    }

    public boolean enableSwipe() {
        if (this.mSerialPort == null || this.waitingForResult) {
            return false;
        }
        UMLog.i(TAG, "SDK starts polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
        this.swipeThread = new SwipeDataReceiver();
        this.waitingForResult = true;
        this.swipeCount = 0;
        this.swipeThread.start();
        return true;
    }

    public boolean enableListen() {
        if (this.mSerialPort == null) {
            return false;
        }
        UMLog.i(TAG, "SDK starts listening card data from reader.");
        if (this.listenThread == null) {
            this.listenThread = new listenForDataOnThread();
            this.listenThread.isRunning = true;
            this.listenThread.start();
        }
        return true;
    }

    public boolean disableListen() {
        UMLog.i(TAG, "SDK stops listening card data from reader.");
        if (this.listenThread == null) {
            return false;
        }
        this.listenThread.isRunning = false;
        return true;
    }

    public boolean enableRead(int timeout, ResDataStruct respData) {
        return true;
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        if (this.mSerialPort == null) {
            return false;
        }
        respData.resData = new byte[1];
        byte[] buff = new byte[4096];
        int res = 0;
        long endTime = System.currentTimeMillis();
        while (endTime - startTime <= (long)(timeout * 1000)) {
            if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                Log.i((String)TAG, (String)"## Transaction Cancelled ");
                return true;
            }
            res = this._readMessage(buff);
            if (res > 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            endTime = System.currentTimeMillis();
        }
        if (endTime - startTime > (long)(timeout * 1000)) {
            return false;
        }
        if (res > 0) {
            respData.resData = null;
            respData.resData = new byte[res];
            System.arraycopy(buff, 0, respData.resData, 0, res);
            UMLog.i("**getResponse**", Common.base16Encode(respData.resData));
            this._msg.com_onReceiveMsgGetResponse(respData.resData);
            return true;
        }
        return false;
    }

    public void disableSwipe() {
        UMLog.i(TAG, "SDK stops polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
        this.waitingForResult = false;
    }

    public boolean isSwipeEnabled() {
        return this.waitingForResult;
    }

    public void setTimeoutOfSwipeCard(int timeoutInSec) {
        UMLog.i(TAG, "Timeout for card swipe changed to " + timeoutInSec + " seconds.");
        this.swipeTimeoutSec = timeoutInSec;
    }

    public void readBuffer(ResDataStruct respData) {
        respData.resData = null;
        if (this.mSerialPort == null || this.mInputStream == null) {
            return;
        }
        this.temp = new byte[4096];
        int dataLen = 0;
        int res = 0;
        if (this.toClose) {
            return;
        }
        try {
            int availbytes = 0;
            int times = 0;
            while (availbytes == 0 && times < 6) {
                availbytes = this.mInputStream.available();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++times;
            }
            if (times >= 6) {
                return;
            }
            res = this.mInputStream.read(this.temp);
        }
        catch (IOException e) {
            res = 0;
        }
        this.waitingForBulkTransfer = false;
        if (res > 7) {
            if (this.temp[1] != 2 || this.temp[4] != 6) {
                return;
            }
            int endPos = -1;
            int i = this.temp.length - 1;
            while (i >= 0) {
                if (this.temp[i] == 3) {
                    endPos = i;
                    break;
                }
                --i;
            }
            if (endPos > 7) {
                byte[] buffer = new byte[endPos + 1];
                System.arraycopy(this.temp, 0, buffer, 0, endPos + 1);
                dataLen = endPos + 1;
                int countPacket64 = buffer.length / 64;
                if (buffer.length % 64 != 0) {
                    ++countPacket64;
                }
                dataLen = buffer.length - countPacket64;
                respData.resData = new byte[dataLen];
                int i2 = 0;
                while (i2 < countPacket64) {
                    int startPos = i2 * 64 + 1;
                    int length = 63;
                    if (i2 == countPacket64 - 1) {
                        length = buffer.length % 64 - 1;
                    }
                    System.arraycopy(buffer, startPos, respData.resData, i2 * 63, length);
                    ++i2;
                }
            } else {
                return;
            }
        }
    }

    public boolean findRS232Device() {
        if (this.mSerialPort == null) {
            String path = "/dev/ttyHSL3";
            int baudrate = 115200;
            if (path.length() == 0 || baudrate == -1) {
                return false;
            }
            try {
                this.mSerialPort = new SerialPort(new File(path), baudrate, 0);
                if (!libRS232Avail) {
                    this.mSerialPort = null;
                    return false;
                }
            }
            catch (SecurityException e) {
                this.mSerialPort = null;
                return false;
            }
            catch (IOException e) {
                this.mSerialPort = null;
                return false;
            }
            this.mInputStream = this.mSerialPort.getInputStream();
            this.mOutputStream = this.mSerialPort.getOutputStream();
            return true;
        }
        return true;
    }

    public byte[] PAT_wakeup_sendCommand(byte[] command, int timeout) {
        if (this.mSerialPort == null || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (command != null) {
            this.write(command, command.length);
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] sendCommand(byte[] command, int timeout) {
        long startTime;
        if (this.mSerialPort == null || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(preSendDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[4096];
        int res = 0;
        if (command != null) {
            this.write(command, command.length);
        }
        UMLog.i("**send command**", Common.base16Encode(command));
        long endTime = startTime = System.currentTimeMillis();
        try {
            Thread.sleep(postSendDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while ((double)(endTime - startTime) <= Common.commandTime * 1000.0) {
            if (IDT_Device.getCancelTransaction()) {
                responseData = null;
                this.waitingForResult = false;
                return responseData;
            }
            res = this.read(buff);
            if (res > 0) {
                if (res <= 12 || buff[10] == command[11]) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                endTime = System.currentTimeMillis();
                res = 0;
                continue;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            endTime = System.currentTimeMillis();
        }
        if ((double)(endTime - startTime) > Common.commandTime * 1000.0) {
            responseData = null;
            responseData = new byte[]{0};
            return responseData;
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**getResponse**", Common.base16Encode(responseData));
            this._msg.com_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        UMLog.i("**getResponse**", "NULL");
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandOnly(byte[] command, int timeout) {
        if (this.mSerialPort == null || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(preSendDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (command != null) {
            this.write(command, command.length);
        }
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandForRKI(byte[] command, int timeout) {
        long startTime;
        if (this.mSerialPort == null || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[1024];
        int res = 0;
        if (command != null) {
            this.write(command, command.length);
        }
        long endTime = startTime = System.currentTimeMillis();
        while ((double)(endTime - startTime) <= Common.commandTime * 1000.0) {
            res = this.readForRKI(buff);
            if (res > 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            endTime = System.currentTimeMillis();
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**getResponse**", Common.base16Encode(responseData));
            this._msg.com_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandFw(byte[] command) {
        if (this.mSerialPort == null || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[4096];
        int res = 0;
        this.write(command, command.length);
        int i = 0;
        while (i < 5) {
            res = this.read(buff);
            if (res > 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            return responseData;
        }
        this.waitingForResult = false;
        return null;
    }

    private int read_org(byte[] data) {
        int totalLen;
        block27: {
            int frameCount;
            int dataLen;
            block28: {
                if (this.mSerialPort == null || this.mInputStream == null) {
                    return 0;
                }
                boolean i = false;
                boolean j = false;
                totalLen = 0;
                dataLen = 0;
                int res = 0;
                Arrays.fill(this.temp, (byte)0);
                byte[] tmp = new byte[64];
                int count = 0;
                frameCount = 0;
                while (res != -1) {
                    block26: {
                        if (this.toClose) {
                            return 0;
                        }
                        this.waitingForBulkTransfer = true;
                        int availbytes = 0;
                        int times = 0;
                        while (availbytes == 0 && times < 6) {
                            availbytes = this.mInputStream.available();
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++times;
                        }
                        if (times < 6) break block26;
                        return 0;
                    }
                    try {
                        res = this.mInputStream.read(tmp);
                    }
                    catch (IOException e) {
                        res = 0;
                    }
                    this.waitingForBulkTransfer = false;
                    if (res != 64) continue;
                    if (count > 4096) break;
                    System.arraycopy(tmp, 0, this.temp, count, 64);
                    if (count == 0) {
                        dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                    }
                    if (dataLen + 16 + ++frameCount <= (count += 64)) break;
                }
                if (!Common.isP2()) break block28;
                dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                if (frameCount > 0) {
                    totalLen = 14 + dataLen + 2;
                }
                if (frameCount < 1) break block27;
                int k = 0;
                while (k < frameCount) {
                    if (frameCount == 1) {
                        boolean allZeros = true;
                        int l = 0;
                        while (l < 64) {
                            if (this.temp[l] != 0) {
                                allZeros = false;
                            }
                            ++l;
                        }
                        if (allZeros) {
                            totalLen = 0;
                            break block27;
                        }
                    }
                    if (k == frameCount - 1) {
                        if (totalLen > 4096) {
                            return 0;
                        }
                        System.arraycopy(this.temp, 1 + 64 * k, data, k * 63, totalLen - k * 63);
                    } else {
                        System.arraycopy(this.temp, 1 + 64 * k, data, k * 63, 63);
                    }
                    ++k;
                }
                break block27;
            }
            if (frameCount == 1) {
                totalLen = 16;
                System.arraycopy(this.temp, 1, data, 0, 16);
            } else if (frameCount > 1) {
                dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                totalLen = 16 + dataLen;
                System.arraycopy(this.temp, 1, data, 0, 14);
                int remainingDataLen = dataLen + 2;
                int index = 14;
                if (this.temp[74] == 68) {
                    if (remainingDataLen <= 53) {
                        System.arraycopy(this.temp, 75, data, index, remainingDataLen);
                        return totalLen;
                    }
                    System.arraycopy(this.temp, 75, data, index, 53);
                    remainingDataLen -= 53;
                    index += 53;
                    int k = 2;
                    while (k < frameCount) {
                        if (63 - remainingDataLen >= 0) {
                            System.arraycopy(this.temp, 1 + 64 * k, data, index, remainingDataLen);
                            break;
                        }
                        System.arraycopy(this.temp, 1 + 64 * k, data, index, 63);
                        remainingDataLen -= 63;
                        index += 63;
                        ++k;
                    }
                }
            }
        }
        return totalLen;
    }

    private int read(byte[] data) {
        int totalLen;
        block29: {
            int frameCount;
            int dataLen;
            block30: {
                if (this.mSerialPort == null || this.mInputStream == null) {
                    return 0;
                }
                boolean i = false;
                boolean j = false;
                totalLen = 0;
                dataLen = 0;
                int res = 0;
                Arrays.fill(this.temp, (byte)0);
                byte[] tmp = new byte[4096];
                int count = 0;
                frameCount = 0;
                while (res != -1) {
                    block28: {
                        if (this.toClose) {
                            return 0;
                        }
                        this.waitingForBulkTransfer = true;
                        int availbytes = 0;
                        int times = 0;
                        while (availbytes == 0 && times < 6) {
                            availbytes = this.mInputStream.available();
                            UMLog.i(TAG, "availbytes: " + availbytes);
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++times;
                        }
                        if (times < 6) break block28;
                        return 0;
                    }
                    try {
                        Arrays.fill(tmp, (byte)0);
                        res = this.mInputStream.read(tmp);
                        String str = Common.base16Encode(tmp);
                        UMLog.i(TAG, "res: " + res + "\ndata: " + str);
                    }
                    catch (IOException e) {
                        res = 0;
                    }
                    this.waitingForBulkTransfer = false;
                    if (res <= 0) continue;
                    if (count > 4096) break;
                    System.arraycopy(tmp, 0, this.temp, count, res);
                    if (count == 0) {
                        dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                    }
                    if (dataLen + 16 <= (count += res)) break;
                }
                frameCount = count / 64;
                if (!Common.isP2()) break block30;
                dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                if (frameCount > 0) {
                    totalLen = 14 + dataLen + 2;
                }
                if (frameCount < 1) break block29;
                int k = 0;
                while (k < frameCount) {
                    if (frameCount == 1) {
                        boolean allZeros = true;
                        int l = 0;
                        while (l < 64) {
                            if (this.temp[l] != 0) {
                                allZeros = false;
                            }
                            ++l;
                        }
                        if (allZeros) {
                            totalLen = 0;
                            break block29;
                        }
                    }
                    if (k == frameCount - 1) {
                        if (totalLen > 4096) {
                            return 0;
                        }
                        if (totalLen - k * 63 > 0) {
                            System.arraycopy(this.temp, 1 + 64 * k, data, k * 63, totalLen - k * 63);
                        } else {
                            totalLen = 0;
                        }
                    } else {
                        System.arraycopy(this.temp, 1 + 64 * k, data, k * 63, 63);
                    }
                    ++k;
                }
                break block29;
            }
            if (frameCount == 1) {
                totalLen = 16;
                System.arraycopy(this.temp, 1, data, 0, 16);
            } else if (frameCount > 1) {
                dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                totalLen = 16 + dataLen;
                System.arraycopy(this.temp, 1, data, 0, 14);
                int remainingDataLen = dataLen + 2;
                int index = 14;
                if (this.temp[74] == 68) {
                    if (remainingDataLen <= 53) {
                        System.arraycopy(this.temp, 75, data, index, remainingDataLen);
                        return totalLen;
                    }
                    System.arraycopy(this.temp, 75, data, index, 53);
                    remainingDataLen -= 53;
                    index += 53;
                    int k = 2;
                    while (k < frameCount) {
                        if (63 - remainingDataLen >= 0) {
                            System.arraycopy(this.temp, 1 + 64 * k, data, index, remainingDataLen);
                            break;
                        }
                        System.arraycopy(this.temp, 1 + 64 * k, data, index, 63);
                        remainingDataLen -= 63;
                        index += 63;
                        ++k;
                    }
                }
            }
        }
        return totalLen;
    }

    private int read_KioskIII(byte[] data) {
        if (this.mSerialPort == null || this.mInputStream == null) {
            return 0;
        }
        int res = 0;
        Arrays.fill(this.temp, (byte)0);
        byte[] tmp = new byte[64];
        int count = 0;
        boolean done = false;
        while (res != -1) {
            block13: {
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                int availbytes = 0;
                int times = 0;
                while (availbytes == 0 && times < 6) {
                    availbytes = this.mInputStream.available();
                    if (availbytes > 0) {
                        UMLog.i(TAG, "availbytes > 0");
                    }
                    if (availbytes == 0 && count > 0) {
                        done = true;
                        break;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++times;
                }
                if (done) break;
                if (times < 6) break block13;
                return 0;
            }
            try {
                res = this.mInputStream.read(tmp);
            }
            catch (IOException e) {
                res = 0;
            }
            this.waitingForBulkTransfer = false;
            if (res == 64) {
                System.arraycopy(tmp, 1, data, count, 63);
                count += 63;
                continue;
            }
            if (res == -1) break;
            if (res == 0 || res <= 0) continue;
            System.arraycopy(tmp, 1, data, count, res);
            count += res - 1;
        }
        while (count - 1 >= 0 && data[count - 1] == 0) {
            --count;
        }
        return count;
    }

    private int readForRKI(byte[] data) {
        if (this.mSerialPort == null || this.mInputStream == null) {
            return 0;
        }
        int i = 0;
        boolean j = false;
        int totalLen = 0;
        int dataLen = 0;
        int res = 0;
        Arrays.fill(this.temp, (byte)0);
        byte[] tmp = new byte[64];
        boolean count = false;
        while (res != -1) {
            block10: {
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                int availbytes = 0;
                int times = 0;
                while (availbytes == 0 && times < 6) {
                    availbytes = this.mInputStream.available();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++times;
                }
                if (times < 6) break block10;
                return 0;
            }
            try {
                res = this.mInputStream.read(tmp);
            }
            catch (IOException e) {
                res = 0;
            }
            this.waitingForBulkTransfer = false;
            if (tmp != null && tmp[1] == 2) break;
        }
        dataLen = (tmp[2] & 0xFF) + (tmp[3] & 0xFF) * 256;
        totalLen = dataLen + 6;
        i = 0;
        while (i < totalLen) {
            data[i] = tmp[i + 1];
            ++i;
        }
        return totalLen;
    }

    private int _readMessage(byte[] data) {
        int times;
        int index;
        byte[] tmp;
        int res;
        int dataLen;
        block28: {
            if (this.mSerialPort == null || this.mInputStream == null) {
                return 0;
            }
            dataLen = 0;
            res = 1;
            tmp = new byte[64];
            index = 0;
            if (this.toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            int availbytes = 0;
            times = 0;
            while (availbytes == 0 && times < 6) {
                availbytes = this.mInputStream.available();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++times;
            }
            if (times < 6) break block28;
            return 0;
        }
        try {
            res = this.mInputStream.read(tmp);
        }
        catch (IOException e) {
            res = 0;
        }
        this.waitingForBulkTransfer = false;
        if (res > 0) {
            dataLen = (tmp[13] & 0xFF) << 8 | tmp[14] & 0xFF;
            if ((dataLen += 16) <= 63) {
                System.arraycopy(tmp, 1, data, index, dataLen);
            } else {
                block30: {
                    System.arraycopy(tmp, 1, data, index, 63);
                    index = 63;
                    while (dataLen - index > 63) {
                        block29: {
                            if (this.toClose) {
                                return 0;
                            }
                            this.waitingForBulkTransfer = true;
                            int availbytes = 0;
                            times = 0;
                            while (availbytes == 0 && times < 6) {
                                availbytes = this.mInputStream.available();
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                ++times;
                            }
                            if (times < 6) break block29;
                            return 0;
                        }
                        try {
                            res = this.mInputStream.read(tmp);
                        }
                        catch (IOException e) {
                            res = 0;
                        }
                        this.waitingForBulkTransfer = false;
                        if (index + 63 > data.length) {
                            return 0;
                        }
                        System.arraycopy(tmp, 1, data, index, 63);
                        index += 63;
                    }
                    if (this.toClose) {
                        return 0;
                    }
                    this.waitingForBulkTransfer = true;
                    int availbytes = 0;
                    times = 0;
                    while (availbytes == 0 && times < 6) {
                        availbytes = this.mInputStream.available();
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++times;
                    }
                    if (times < 6) break block30;
                    return 0;
                }
                try {
                    res = this.mInputStream.read(tmp);
                }
                catch (IOException e) {
                    res = 0;
                }
                this.waitingForBulkTransfer = false;
                if (dataLen > data.length) {
                    return 0;
                }
                System.arraycopy(tmp, 1, data, index, dataLen - index);
            }
        }
        return dataLen;
    }

    public SerialPort getConnection() {
        return this.mSerialPort;
    }

    public int readMSR(byte[] data) {
        int res;
        int dataLen;
        int totalLen;
        int j;
        int i;
        block20: {
            if (this.mSerialPort == null || this.mInputStream == null) {
                return 0;
            }
            this.temp = new byte[4096];
            i = 0;
            j = 0;
            totalLen = 0;
            dataLen = 0;
            res = 0;
            if (this.toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            int availbytes = 0;
            int times = 0;
            while (availbytes == 0 && times < 6) {
                availbytes = this.mInputStream.available();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++times;
            }
            if (times < 6) break block20;
            return 0;
        }
        try {
            res = this.mInputStream.read(this.temp);
        }
        catch (IOException e) {
            res = 0;
        }
        this.waitingForBulkTransfer = false;
        if (res > 0) {
            if (this.temp[1] == 2 && (totalLen = this.temp[0] & 0xFF) == (dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256) + 6 && totalLen < 64) {
                i = 0;
                while (i < totalLen + 1) {
                    data[i] = this.temp[i + 1];
                    ++i;
                }
                return totalLen;
            }
            totalLen = this.temp[0] & 0xFF;
            dataLen = (this.temp[3] & 0xFF) + (this.temp[4] & 0xFF) * 256;
            if (totalLen < 64) {
                i = 0;
                while (i < totalLen + 1) {
                    data[i] = this.temp[i + 1];
                    ++i;
                }
                return totalLen;
            }
            if (totalLen == 191) {
                dataLen = 0;
                j = 0;
                i = 0;
                while (i + j < 4096) {
                    if ((i + j) % 64 == 0) {
                        totalLen = this.temp[i + j] & 0xFF;
                        if (totalLen == 191) {
                            dataLen += 63;
                        } else {
                            if (totalLen < 64 && totalLen > 0) {
                                dataLen += totalLen;
                                ++j;
                                int k = 0;
                                while (k < totalLen) {
                                    data[i + k] = this.temp[i + j + k];
                                    ++k;
                                }
                                return dataLen;
                            }
                            if (totalLen == 0) break;
                        }
                        ++j;
                    }
                    data[i] = this.temp[i + j];
                    ++i;
                }
                return dataLen;
            }
        }
        return 0;
    }

    public boolean close() {
        this.toClose = true;
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (this.waitingForBulkTransfer);
        if (this.mSerialPort != null) {
            this.mSerialPort.close();
            this.mSerialPort = null;
            this.mInputStream = null;
            this.mOutputStream = null;
        }
        System.gc();
        return true;
    }

    public int writeNothing() {
        if (this.mSerialPort == null || this.mOutputStream == null) {
            return 0;
        }
        int res = 0;
        int iii = 0;
        do {
            ++iii;
            if (this.toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            try {
                this.mOutputStream.write(null);
            }
            catch (IOException e) {
                res = 0;
            }
            this.waitingForBulkTransfer = false;
            UMLog.i("**RS232 bulkTransfer**", "write res=" + res);
        } while (res != 0 && iii < 10);
        return res;
    }

    public int write_new(byte[] command, int length) {
        if (length <= 0) {
            return 0;
        }
        if (this.mSerialPort == null || this.mOutputStream == null) {
            return 0;
        }
        int res = 0;
        if (length >= 64) {
            int len = (length - 1) / 63 + 1 + length;
            byte[] com = new byte[len];
            int j = 0;
            int i = 0;
            while (i < len) {
                if (i % 64 == 0) {
                    ++j;
                    com[i] = len - i > 64 ? -65 : (len - i < 64 ? (int)(length % 63) : 63);
                } else {
                    com[i] = command[i - j];
                }
                ++i;
            }
            int iii = 0;
            while (iii * 64 < len) {
                byte[] temp = new byte[64];
                if ((iii + 1) * 64 > len) {
                    System.arraycopy(com, 64 * iii, temp, 0, len - iii * 64);
                } else {
                    System.arraycopy(com, 64 * iii, temp, 0, 64);
                }
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                try {
                    this.mOutputStream.write(temp, 0, 64);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.waitingForBulkTransfer = false;
                UMLog.i("**RS232 bulkTransfer 1**", "write res=" + res);
                ++iii;
            }
        } else {
            if (this.toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            try {
                command[0] = 1;
                this.mOutputStream.write(command, 0, length);
                res = length;
            }
            catch (IOException e) {
                res = 0;
            }
            this.waitingForBulkTransfer = false;
            UMLog.i("**RS232 bulkTransfer 2**", "write res=" + res);
        }
        UMLog.i("**RS232 SEND**", "write res=" + res);
        return res;
    }

    public int write(byte[] command, int length) {
        if (length <= 0) {
            return 0;
        }
        if (this.mSerialPort == null || this.mOutputStream == null) {
            return 0;
        }
        int res = 0;
        if (length > 64) {
            int len = (length - 1) / 63 + 1 + (length - 1);
            byte[] com = new byte[len];
            int times = len / 64 + 1;
            int i = 0;
            while (i < times) {
                if (i == times - 1) {
                    com[i * 64] = 4;
                    System.arraycopy(command, 63 * i + 1, com, 64 * i + 1, length - 1 - i * 63);
                } else if (i == 0) {
                    com[0] = 2;
                    System.arraycopy(command, 1, com, 1, 63);
                } else {
                    com[i * 64] = 3;
                    System.arraycopy(command, 63 * i + 1, com, 64 * i + 1, 63);
                }
                ++i;
            }
            int iii = 0;
            while (iii * 64 < len) {
                byte[] temp = new byte[64];
                if ((iii + 1) * 64 > len) {
                    System.arraycopy(com, 64 * iii, temp, 0, len - iii * 64);
                } else {
                    System.arraycopy(com, 64 * iii, temp, 0, 64);
                }
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                try {
                    if ((iii + 1) * 64 > len) {
                        this.mOutputStream.write(temp, 0, len - iii * 64);
                        res = len - iii * 64;
                    } else {
                        this.mOutputStream.write(temp, 0, 64);
                        res = 64;
                    }
                }
                catch (IOException e) {
                    res = 0;
                }
                this.waitingForBulkTransfer = false;
                UMLog.i("**RS232 bulkTransfer 1**", "write res=" + res);
                ++iii;
            }
        } else {
            if (this.toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            try {
                command[0] = 1;
                this.mOutputStream.write(command, 0, length);
                res = length;
            }
            catch (IOException e) {
                res = 0;
            }
            this.waitingForBulkTransfer = false;
            UMLog.i("**USB bulkTransfer 2**", "write res=" + res);
        }
        UMLog.i("**RS232 SEND**", "write res=" + res);
        return res;
    }

    private class CheckDeviceThread
    extends Thread {
        boolean res = false;

        private CheckDeviceThread() {
        }

        public void run() {
            try {
                CheckDeviceThread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (!this.res) {
                if (RS232Controller.this.mSerialPort != null) break;
                this.res = RS232Controller.this.initWithThread();
                try {
                    CheckDeviceThread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class SwipeDataReceiver
    extends Thread {
        private boolean swipeCancelled = false;

        private SwipeDataReceiver() {
        }

        public void run() {
            while (RS232Controller.this.swipeCount < RS232Controller.this.swipeTimeoutSec && !this.swipeCancelled) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int length = RS232Controller.this.readMSR(RS232Controller.this.swipeBuffer);
                if (length > 0) {
                    this.swipeCancelled = true;
                    IDTMSRData card = new IDTMSRData();
                    byte[] cardData = new byte[length];
                    System.arraycopy(RS232Controller.this.swipeBuffer, 0, cardData, 0, length);
                    if (cardData[0] == 2 && (cardData[3] == -128 || cardData[3] == -127 || cardData[3] == -125 || cardData[3] == -124 || cardData[3] == -123 || cardData[3] == -122 || cardData[3] == -64)) {
                        Common.Response.parseCardData(cardData, card, 0);
                    } else if (cardData[1] == 2 && (RS232Controller.this.temp[4] == -128 || cardData[4] == -127 || cardData[4] == -125 || cardData[4] == -124 || cardData[4] == -123 || cardData[4] == -122 || cardData[4] == -64)) {
                        Common.Response.parseCardDataUniPay(cardData, card);
                    } else {
                        Common.Response.parseCardClearData(cardData, card);
                    }
                    UMLog.i(RS232Controller.TAG, "got: " + Common.getByteArrDesc(RS232Controller.this.swipeBuffer));
                    RS232Controller.this._msg.com_onReceiveMsgCardData(card);
                    break;
                }
                RS232Controller rS232Controller = RS232Controller.this;
                rS232Controller.swipeCount = rS232Controller.swipeCount + 1;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (RS232Controller.this.swipeCount >= RS232Controller.this.swipeTimeoutSec) {
                this.close();
                RS232Controller.this._msg.com_onReceiveMsgSwipeTimeout();
            }
            RS232Controller.this.waitingForResult = false;
            IDT_Device.isCommandRunning = false;
        }

        public void close() {
            this.swipeCancelled = true;
        }
    }

    private class listenForDataOnThread
    extends Thread {
        public boolean isRunning = true;

        private listenForDataOnThread() {
        }

        public void run() {
            byte[] tmp = new byte[4096];
            while (this.isRunning) {
                if (!IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || IDT_Device.isCommandRunning || Common.getBootLoaderMode()) {
                    IDTMSRData card;
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn) continue;
                    try {
                        Thread.sleep(950L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isCommandRunning) continue;
                    if (IDT_Device.isMonitorCtlsData) {
                        card = new IDTMSRData();
                        byte[] command = Common.getByteArray("5669564F7465636832000340000096E2");
                        byte[] data = RS232Controller.this.sendCommand(command, 1);
                        int len = 0;
                        if (data != null && data.length > 13) {
                            len = (data[12] & 0xFF) * 256 + (data[13] & 0xFF);
                        }
                        if (len > 7) {
                            Common.parseCardData3in1(data, card);
                            UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                            RS232Controller.this._msg.com_onReceiveMsgCardData(card);
                            continue;
                        }
                        card.result = 61092;
                        RS232Controller.this._msg.com_onReceiveMsgCardData(card);
                        continue;
                    }
                    card = new IDTMSRData();
                    card.result = 61092;
                    RS232Controller.this._msg.com_onReceiveMsgCardData(card);
                    continue;
                }
                IDT_Device.isCheckingNotification = true;
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IDT_Device.isThreadReading = true;
                int length = RS232Controller.this.read_KioskIII(tmp);
                IDT_Device.isThreadReading = false;
                if (length > 0) {
                    IDTMSRData card;
                    if (length > 12 && tmp[10] == 2 && tmp[11] == -96) {
                        card = new IDTMSRData();
                        card.result = 61088;
                        RS232Controller.this._msg.com_onReceiveMsgCardData(card);
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (length > 12 && tmp[10] == -18 && tmp[11] == -16) {
                        card = new IDTMSRData();
                        card.result = 61168;
                        RS232Controller.this._msg.com_onReceiveMsgCardData(card);
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    byte[] data = new byte[length];
                    System.arraycopy(tmp, 0, data, 0, length);
                    IDTMSRData card2 = new IDTMSRData();
                    Common.processCTLSData(data, card2);
                    UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                    RS232Controller.this._msg.com_onReceiveMsgCardData(card2);
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IDT_Device.isCheckingNotification = false;
            }
            RS232Controller.this.listenThread = null;
        }
    }
}

