/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import com.idtechproducts.device.audiojack.io.CommandManageUARTWaveform;

public class CommandManageUARTWaveform48K
extends CommandManageUARTWaveform {
    byte[] peak2idleSmooth = new byte[20];
    byte[] valley2idelSmooth = new byte[20];
    byte[] idle2peakSmooth = new byte[4];
    byte[] idel2valleySmooth = new byte[4];
    byte[] smooth = new byte[40];
    byte[] smoothFromIdle = new byte[8];
    byte[] lineFrame = new byte[]{-128, -128, -128, -128, -128, -128, -128, -128, -128, -128};
    byte[] negativeFrameLine = new byte[]{1, -1, 1, -1, 1, -1, 1, -1, 1, -1};
    byte[] positiveFrameLine = new byte[]{-1, 1, -1, 1, -1, 1, -1, 1, -1, 1};
    byte[] negativeFrame = new byte[]{1, -1, 1, -1, 1, -1, 1, -1, 1, -1};
    byte[] positiveFrame = new byte[]{-1, 1, -1, 1, -1, 1, -1, 1, -1, 1};
    byte[] negativeFrameFlat = new byte[]{1, -1, 1, -1, 1, -1, 1, -1, 1, -1};
    byte[] positiveFrameFlat = new byte[]{-1, 1, -1, 1, -1, 1, -1, 1, -1, 1};
    byte[] endFrame = new byte[]{-1, 1, -1, 1, -1, 1, -1, 1};

    public void adjustDirection(int directionOutput) {
        int i = 0;
        while (i < 20) {
            this.peak2idleSmooth[i] = (byte)(255 - (i + 1) * 6);
            ++i;
        }
        i = 0;
        while (i < 20) {
            this.valley2idelSmooth[i] = (byte)((i + 1) * 6);
            ++i;
        }
        this.idle2peakSmooth[3] = -34;
        this.idle2peakSmooth[2] = -66;
        this.idle2peakSmooth[1] = -98;
        this.idle2peakSmooth[0] = -117;
        this.idel2valleySmooth[3] = 12;
        this.idel2valleySmooth[2] = 31;
        this.idel2valleySmooth[1] = 63;
        this.idel2valleySmooth[0] = 95;
        if (directionOutput == 1) {
            this.positiveFrameLine[0] = 1;
            this.positiveFrameLine[1] = -1;
            this.positiveFrameLine[2] = 1;
            this.positiveFrameLine[3] = -1;
            this.positiveFrameLine[4] = 1;
            this.positiveFrameLine[5] = -1;
            this.positiveFrameLine[6] = 1;
            this.positiveFrameLine[7] = -1;
            this.positiveFrameLine[8] = 1;
            this.positiveFrameLine[9] = -1;
            this.positiveFrame[0] = 1;
            this.positiveFrame[1] = -1;
            this.positiveFrame[2] = 1;
            this.positiveFrame[3] = -1;
            this.positiveFrame[4] = 1;
            this.positiveFrame[5] = -1;
            this.positiveFrame[6] = 1;
            this.positiveFrame[7] = -1;
            this.positiveFrame[8] = 1;
            this.positiveFrame[9] = -1;
            this.negativeFrame[0] = -1;
            this.negativeFrame[1] = 1;
            this.negativeFrame[2] = -1;
            this.negativeFrame[3] = 1;
            this.negativeFrame[4] = -1;
            this.negativeFrame[5] = 1;
            this.negativeFrame[6] = -1;
            this.negativeFrame[7] = 1;
            this.negativeFrame[8] = -1;
            this.negativeFrame[9] = 1;
            this.positiveFrameFlat[0] = 1;
            this.positiveFrameFlat[1] = -1;
            this.positiveFrameFlat[2] = 1;
            this.positiveFrameFlat[3] = -1;
            this.positiveFrameFlat[4] = 1;
            this.positiveFrameFlat[5] = -1;
            this.positiveFrameFlat[6] = 1;
            this.positiveFrameFlat[7] = -1;
            this.positiveFrameFlat[8] = 1;
            this.positiveFrameFlat[9] = -1;
            this.negativeFrameFlat[0] = -1;
            this.negativeFrameFlat[1] = 1;
            this.negativeFrameFlat[2] = -1;
            this.negativeFrameFlat[3] = 1;
            this.negativeFrameFlat[4] = -1;
            this.negativeFrameFlat[5] = 1;
            this.negativeFrameFlat[6] = -1;
            this.negativeFrameFlat[7] = 1;
            this.negativeFrameFlat[8] = -1;
            this.negativeFrameFlat[9] = 1;
            this.endFrame[0] = -1;
            this.endFrame[1] = 1;
            this.endFrame[2] = -1;
            this.endFrame[3] = 1;
            this.endFrame[4] = -1;
            this.endFrame[5] = 1;
            this.endFrame[6] = -1;
            this.endFrame[7] = 1;
            i = 0;
            while (i < 20) {
                this.smooth[i * 2] = this.valley2idelSmooth[i];
                this.smooth[i * 2 + 1] = this.peak2idleSmooth[i];
                ++i;
            }
            this.smoothFromIdle[0] = this.idle2peakSmooth[0];
            this.smoothFromIdle[1] = this.idel2valleySmooth[0];
            this.smoothFromIdle[2] = this.idle2peakSmooth[1];
            this.smoothFromIdle[3] = this.idel2valleySmooth[1];
            this.smoothFromIdle[4] = this.idle2peakSmooth[2];
            this.smoothFromIdle[5] = this.idel2valleySmooth[2];
            this.smoothFromIdle[6] = this.idle2peakSmooth[3];
            this.smoothFromIdle[7] = this.idel2valleySmooth[3];
        } else if (directionOutput == 0) {
            this.positiveFrameLine[0] = -1;
            this.positiveFrameLine[1] = 1;
            this.positiveFrameLine[2] = -1;
            this.positiveFrameLine[3] = 1;
            this.positiveFrameLine[4] = -1;
            this.positiveFrameLine[5] = 1;
            this.positiveFrameLine[6] = -1;
            this.positiveFrameLine[7] = 1;
            this.positiveFrameLine[8] = -1;
            this.positiveFrameLine[9] = 1;
            this.positiveFrame[0] = -128;
            this.positiveFrame[1] = -128;
            this.positiveFrame[2] = -1;
            this.positiveFrame[3] = 1;
            this.positiveFrame[4] = -1;
            this.positiveFrame[5] = 1;
            this.positiveFrame[6] = -1;
            this.positiveFrame[7] = 1;
            this.positiveFrame[8] = -1;
            this.positiveFrame[9] = 1;
            this.negativeFrame[0] = -128;
            this.negativeFrame[1] = -128;
            this.negativeFrame[2] = 1;
            this.negativeFrame[3] = -1;
            this.negativeFrame[4] = 1;
            this.negativeFrame[5] = -1;
            this.negativeFrame[6] = 1;
            this.negativeFrame[7] = -1;
            this.negativeFrame[8] = 1;
            this.negativeFrame[9] = -1;
            this.positiveFrameFlat[0] = -1;
            this.positiveFrameFlat[1] = 1;
            this.positiveFrameFlat[2] = -1;
            this.positiveFrameFlat[3] = 1;
            this.positiveFrameFlat[4] = -1;
            this.positiveFrameFlat[5] = 1;
            this.positiveFrameFlat[6] = -1;
            this.positiveFrameFlat[7] = 1;
            this.positiveFrameFlat[8] = -1;
            this.positiveFrameFlat[9] = 1;
            this.negativeFrameFlat[0] = 1;
            this.negativeFrameFlat[1] = -1;
            this.negativeFrameFlat[2] = 1;
            this.negativeFrameFlat[3] = -1;
            this.negativeFrameFlat[4] = 1;
            this.negativeFrameFlat[5] = -1;
            this.negativeFrameFlat[6] = 1;
            this.negativeFrameFlat[7] = -1;
            this.negativeFrameFlat[8] = 1;
            this.negativeFrameFlat[9] = -1;
            i = 0;
            while (i < 20) {
                this.smooth[i * 2] = this.peak2idleSmooth[i];
                this.smooth[i * 2 + 1] = this.valley2idelSmooth[i];
                ++i;
            }
            this.smoothFromIdle[0] = this.idel2valleySmooth[0];
            this.smoothFromIdle[1] = this.idle2peakSmooth[0];
            this.smoothFromIdle[2] = this.idel2valleySmooth[1];
            this.smoothFromIdle[3] = this.idle2peakSmooth[1];
            this.smoothFromIdle[4] = this.idel2valleySmooth[2];
            this.smoothFromIdle[5] = this.idle2peakSmooth[2];
            this.smoothFromIdle[6] = this.idel2valleySmooth[3];
            this.smoothFromIdle[7] = this.idle2peakSmooth[3];
        }
    }

    public byte[] getWaveBufferDataByFlag(byte halfByte) {
        int writePos = 0;
        byte[] realBuffer = new byte[this.positiveFrame.length * 10];
        boolean previouseBit = false;
        System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
        writePos += this.negativeFrame.length;
        byte flag = (byte)(halfByte >> 4 & 0xF);
        switch (flag) {
            case 0: {
                byte oneBit = 0;
                byte fourBits = halfByte;
                int i = 0;
                while (i < 4) {
                    oneBit = (byte)(fourBits & 1);
                    if (oneBit == 0) {
                        if (!previouseBit) {
                            System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                            System.arraycopy(this.negativeFrame, 0, realBuffer, writePos += this.positiveFrame.length, this.negativeFrame.length);
                            writePos += this.negativeFrame.length;
                        } else if (previouseBit) {
                            System.arraycopy(this.positiveFrameFlat, 0, realBuffer, writePos, this.positiveFrameFlat.length);
                            System.arraycopy(this.negativeFrame, 0, realBuffer, writePos += this.positiveFrameFlat.length, this.negativeFrame.length);
                            writePos += this.negativeFrame.length;
                        }
                        previouseBit = false;
                    } else {
                        if (!previouseBit) {
                            System.arraycopy(this.negativeFrameFlat, 0, realBuffer, writePos, this.negativeFrameFlat.length);
                            System.arraycopy(this.positiveFrame, 0, realBuffer, writePos += this.negativeFrameFlat.length, this.positiveFrame.length);
                            writePos += this.positiveFrame.length;
                        } else if (previouseBit) {
                            System.arraycopy(this.negativeFrame, 0, realBuffer, writePos, this.negativeFrame.length);
                            System.arraycopy(this.positiveFrame, 0, realBuffer, writePos += this.negativeFrame.length, this.positiveFrame.length);
                            writePos += this.positiveFrame.length;
                        }
                        previouseBit = true;
                    }
                    fourBits = (byte)(halfByte >> 1 + i);
                    ++i;
                }
                if (!previouseBit) {
                    System.arraycopy(this.positiveFrame, 0, realBuffer, writePos, this.positiveFrame.length);
                    writePos += this.positiveFrame.length;
                    break;
                }
                if (!previouseBit) break;
                System.arraycopy(this.positiveFrameFlat, 0, realBuffer, writePos, this.positiveFrameFlat.length);
                writePos += this.positiveFrameFlat.length;
                break;
            }
            case 15: {
                writePos = 0;
                realBuffer = null;
                realBuffer = new byte[this.positiveFrameLine.length];
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.positiveFrameLine, 0, realBuffer, writePos, this.positiveFrameLine.length);
                    writePos += this.positiveFrameLine.length;
                    ++i;
                }
                break;
            }
            case 7: {
                realBuffer = null;
                realBuffer = new byte[this.lineFrame.length];
                writePos = 0;
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.lineFrame, 0, realBuffer, writePos, this.lineFrame.length);
                    writePos += this.lineFrame.length;
                    ++i;
                }
                break;
            }
            case 6: {
                realBuffer = null;
                realBuffer = new byte[this.smooth.length];
                writePos = 0;
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.smooth, 0, realBuffer, writePos, this.smooth.length);
                    writePos += this.smooth.length;
                    ++i;
                }
                break;
            }
            case 5: {
                realBuffer = null;
                realBuffer = new byte[this.smoothFromIdle.length];
                writePos = 0;
                int i = 0;
                while (i < 1) {
                    System.arraycopy(this.smoothFromIdle, 0, realBuffer, writePos, this.smoothFromIdle.length);
                    writePos += this.smoothFromIdle.length;
                    ++i;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return realBuffer;
    }
}

