/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.util.Log;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.USBBypassListener;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.usb.IDTechUsbHidMsg;
import com.idtechproducts.device.usb.UsbControllerMsg;
import java.util.Arrays;
import java.util.HashMap;

public final class UsbController {
    private static final String ACTION_USB_PERMISSION = "com.idtechproducts.usbhid.USB_PERMISSION";
    private static final String TAG = "SDK::USB Controller";
    private final int VID;
    private final int PID;
    private UsbManager mManager = null;
    private PendingIntent pi;
    private UsbDevice usbDevice = null;
    private UsbInterface usbInterface = null;
    private UsbDeviceConnection connection = null;
    private UsbEndpoint epIn = null;
    private UsbEndpoint epOut = null;
    private Context ctx = null;
    private IDTechUsbHidMsg _msg = null;
    private UsbControllerMsg _usbMsg = null;
    private IPermissionListener mlistener = null;
    private IntentFilter mUsbFilter = null;
    private CheckDeviceThread checkThread;
    private USBBypassListener m_recListener = null;
    private boolean waitingForResult = false;
    private boolean waitingForBulkTransfer = false;
    private boolean toClose = false;
    private int swipeTimeoutSec;
    private int swipeCount = 0;
    private SwipeDataReceiver swipeThread;
    private listenForDataOnThread listenThread = null;
    private byte[] swipeBuffer;
    private byte[] cmdBuffer;
    private byte[] temp;
    private Handler mainHandler = null;
    private CommandDataReceiver commandThread;
    private int cmdID = -1;
    private int dataCount = 0;
    private static final int PAUSE_SWIPE_READ = 10;
    private static final int PAUSE_COMMAND_READ = 30;
    private static final int PAUSE_BEFORE_READ_BUFFER = 500;
    private static final int PAUSE_BEFORE_READ_BUFFER_LONGER = 1000;
    private String cmdBufferRet = "";
    private byte[] previousCmdBuffer = null;
    private byte[] secureMagBuf = null;
    Runnable deviceAttached = new Runnable(){

        public void run() {
            UMLog.i(UsbController.TAG, "Sending attached for device_filter");
            UsbController.this._usbMsg.onDeviceAttached();
        }
    };
    private static boolean _inThreadLoop = false;
    private boolean registered = false;
    public static int preSendDelay = 0;
    public static int postSendDelay = 0;
    private BroadcastReceiver mPermissionReceiver = new PermissionReceiver(new IPermissionListener(){

        public void onPermissionDenied(UsbDevice d) {
            UMLog.i(UsbController.TAG, "Permission denied on " + d.getDeviceId());
        }
    });
    private BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            String action = intent.getAction();
            if (action.equals("android.hardware.usb.action.USB_DEVICE_DETACHED") && (device = (UsbDevice)intent.getParcelableExtra("device")) != null && device.getVendorId() == UsbController.this.VID && device.getProductId() == UsbController.this.PID) {
                UMLog.i(UsbController.TAG, "USB device detached: " + device.getVendorId());
                if (UsbController.this._usbMsg != null && UsbController.this._msg != null) {
                    UsbController.this._usbMsg.onDeviceDetached();
                }
            }
        }
    };

    public void externalConnect() {
        if (IDT_Device.getUSBBypass() && this._usbMsg != null) {
            IDT_Device.allowReceiverCallback = true;
            this._usbMsg.onDeviceAttached();
        }
    }

    public void externalDisconnect() {
        if (IDT_Device.getUSBBypass() && this._usbMsg != null) {
            this._usbMsg.onDeviceDetached();
        }
    }

    public void externalDeviceNotFound() {
        if (IDT_Device.getUSBBypass() && this._usbMsg != null) {
            this._usbMsg.onDeviceNotFound();
        }
    }

    public UsbController(Context context, IDTechUsbHidMsg msg, UsbControllerMsg msg2, int vid, int pid, USBBypassListener listen) {
        this.m_recListener = listen;
        this.ctx = context;
        this.VID = vid;
        this.PID = pid;
        this._msg = msg;
        this._usbMsg = msg2;
        this.swipeBuffer = new byte[4096];
        this.cmdBuffer = new byte[8];
        this.temp = new byte[4096];
        this.swipeTimeoutSec = 200;
        this.mManager = (UsbManager)this.ctx.getSystemService("usb");
        this.mainHandler = new Handler(context.getMainLooper());
    }

    public boolean init() {
        if (IDT_Device.getUSBBypass()) {
            this.m_recListener.connectToDevice();
            return true;
        }
        this.mlistener = new IPermissionListener(){

            public void onPermissionDenied(UsbDevice d) {
                if (!IDT_Device._isDeviceFilter) {
                    UMLog.i(UsbController.TAG, "Asking a permission for accessing USB-HID device");
                    UsbController.this.mManager.requestPermission(d, UsbController.this.pi);
                }
            }
        };
        if (this.findUsbHidDevice(this.mlistener)) {
            UMLog.i(TAG, "USB-HID device is found.");
            return true;
        }
        UMLog.i(TAG, "USB-HID device is not found.");
        this._usbMsg.onDeviceNotFound();
        return false;
    }

    public boolean initWithThread() {
        if (_inThreadLoop) {
            return false;
        }
        if (IDT_Device.getUSBBypass()) {
            this.m_recListener.connectToDevice();
            return true;
        }
        _inThreadLoop = true;
        this.mlistener = new IPermissionListener(){

            public void onPermissionDenied(UsbDevice d) {
                if (!IDT_Device._isDeviceFilter) {
                    UMLog.i(UsbController.TAG, "Asking a permission for accessing USB-HID device");
                    UsbController.this.mManager.requestPermission(d, UsbController.this.pi);
                }
            }
        };
        if (this.findUsbHidDevice(this.mlistener)) {
            UMLog.i(TAG, "USB-HID device is found.");
            UMLog.i(TAG, "Permission Granted");
            if (IDT_Device._isDeviceFilter) {
                UMLog.i(TAG, "Sending attached for device_filter");
                this.mainHandler.post(this.deviceAttached);
            }
            _inThreadLoop = false;
            return true;
        }
        _inThreadLoop = false;
        return false;
    }

    public void startCheckingConnection() {
        if (IDT_Device.getUSBBypass()) {
            return;
        }
        UMLog.i(TAG, "SDK starts monitoring if reader is connected.");
        this.checkThread = new CheckDeviceThread();
        this.checkThread.start();
    }

    public boolean isRegistered() {
        if (IDT_Device.getUSBBypass()) {
            return true;
        }
        return this.registered;
    }

    public void registerReceiver() {
        if (IDT_Device.getUSBBypass()) {
            return;
        }
        UMLog.i(TAG, "Register a Broadcast receiver to get UsbManager.ACTION_USB_DEVICE_DETACHED.");
        if (this.mUsbFilter == null) {
            this.mUsbFilter = new IntentFilter();
            this.mUsbFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        }
        this.ctx.registerReceiver(this.mUsbReceiver, this.mUsbFilter);
        this.pi = PendingIntent.getBroadcast((Context)this.ctx, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        this.ctx.registerReceiver(this.mPermissionReceiver, new IntentFilter(ACTION_USB_PERMISSION));
        this.registered = true;
    }

    public void unregisterReceiver() {
        if (IDT_Device.getUSBBypass()) {
            this.registered = false;
            return;
        }
        UMLog.i(TAG, "A Broadcast receiver unregistered.");
        this.ctx.unregisterReceiver(this.mUsbReceiver);
        this.ctx.unregisterReceiver(this.mPermissionReceiver);
        this.close();
        this.mUsbFilter = null;
        this.registered = false;
    }

    public boolean enableSwipe() {
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
            if (this.connection == null || this.waitingForResult) {
                return false;
            }
            UMLog.i(TAG, "Set Auto Mode...");
            byte[] command = new byte[]{2, 83, 26, 1, 49, 3, 120};
            this.sendCommand(command, 21);
            UMLog.i(TAG, "SDK starts polling card data from reader.");
            this.swipeThread = new SwipeDataReceiver();
            this.swipeThread.start();
            return true;
        }
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            return false;
        }
        UMLog.i(TAG, "SDK starts polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
        this.swipeThread = new SwipeDataReceiver();
        this.waitingForResult = true;
        this.swipeCount = 0;
        this.swipeThread.start();
        return true;
    }

    public boolean enableListen() {
        if (this.connection == null && !IDT_Device.getUSBBypass()) {
            return false;
        }
        UMLog.i(TAG, "SDK starts listening card data from reader.");
        if (this.listenThread == null) {
            this.listenThread = new listenForDataOnThread();
            this.listenThread.isRunning = true;
            this.listenThread.start();
        }
        return true;
    }

    public boolean disableListen() {
        UMLog.i(TAG, "SDK stops listening card data from reader.");
        if (this.listenThread == null) {
            return false;
        }
        this.listenThread.isRunning = false;
        return true;
    }

    public boolean enableRead(int timeout, ResDataStruct respData) {
        if (this.connection == null && !IDT_Device.getUSBBypass()) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        UMLog.i(TAG, "SDK starts polling data from reader.");
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA) {
            byte[] byArray = new byte[3];
            byArray[0] = 21;
            byArray[1] = -127;
            respData.resData = byArray;
        } else {
            byte[] byArray = new byte[3];
            byArray[1] = 13;
            respData.resData = byArray;
        }
        while (System.currentTimeMillis() - startTime < (long)((timeout + 10) * 1000)) {
            int length = this.readMSR(this.swipeBuffer);
            if (length > 0) {
                if (this.swipeBuffer[3] != 6) {
                    return false;
                }
                respData.resData = new byte[length - 1];
                System.arraycopy(this.swipeBuffer, 1, respData.resData, 0, length - 1);
                UMLog.i(TAG, "got: " + Common.getByteArrDesc(this.swipeBuffer));
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (timeout != 0) continue;
            startTime = System.currentTimeMillis();
        }
        return true;
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        if (this.connection == null && !IDT_Device.getUSBBypass()) {
            return false;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            respData.resData = new byte[1];
        } else {
            byte[] byArray = new byte[3];
            byArray[0] = 21;
            byArray[1] = -127;
            respData.resData = byArray;
        }
        byte[] buff = new byte[4096];
        int res = 0;
        long endTime = System.currentTimeMillis();
        while (endTime - startTime <= (long)(timeout * 1000)) {
            if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                Log.i((String)TAG, (String)"## Transaction Cancelled ");
                return true;
            }
            res = this._readMessage(buff);
            if (res > 0) {
                if (!ignoreLCDMsg || Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || res <= 12 || buff[10] != 97 || buff[11] != 1) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                res = 0;
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            endTime = System.currentTimeMillis();
        }
        if (endTime - startTime > (long)(timeout * 1000)) {
            return false;
        }
        if (res > 0) {
            respData.resData = null;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                respData.resData = new byte[res];
                System.arraycopy(buff, 0, respData.resData, 0, res);
                UMLog.i("**getResponse**", Common.base16Encode(respData.resData));
                this._msg.usb_onReceiveMsgGetResponse(respData.resData);
            } else {
                respData.resData = new byte[res - 6];
                byte[] fullNGA = new byte[res];
                System.arraycopy(buff, 3, respData.resData, 0, res - 6);
                System.arraycopy(buff, 0, fullNGA, 0, res);
                UMLog.i("**getResponse**", Common.base16Encode(fullNGA));
                this._msg.usb_onReceiveMsgGetResponse(fullNGA);
            }
            return true;
        }
        return false;
    }

    public void disableSwipe() {
        UMLog.i(TAG, "SDK stops polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
        this.waitingForResult = false;
    }

    public boolean isSwipeEnabled() {
        return this.waitingForResult;
    }

    public void setTimeoutOfSwipeCard(int timeoutInSec) {
        UMLog.i(TAG, "Timeout for card swipe changed to " + timeoutInSec + " seconds.");
        this.swipeTimeoutSec = timeoutInSec;
    }

    public void readBuffer(ResDataStruct respData) {
        respData.resData = null;
        if (this.connection == null) {
            return;
        }
        this.temp = new byte[4096];
        int dataLen = 0;
        int res = 0;
        if (this.toClose) {
            return;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(this.epIn, this.temp, 4096, 300);
        this.waitingForBulkTransfer = false;
        if (res > 7) {
            if (this.temp[1] != 2 || this.temp[4] != 6) {
                return;
            }
            int endPos = -1;
            int i = this.temp.length - 1;
            while (i >= 0) {
                if (this.temp[i] == 3) {
                    endPos = i;
                    break;
                }
                --i;
            }
            if (endPos > 7) {
                byte[] buffer = new byte[endPos + 1];
                System.arraycopy(this.temp, 0, buffer, 0, endPos + 1);
                dataLen = endPos + 1;
                int countPacket64 = buffer.length / 64;
                if (buffer.length % 64 != 0) {
                    ++countPacket64;
                }
                dataLen = buffer.length - countPacket64;
                respData.resData = new byte[dataLen];
                int i2 = 0;
                while (i2 < countPacket64) {
                    int startPos = i2 * 64 + 1;
                    int length = 63;
                    if (i2 == countPacket64 - 1) {
                        length = buffer.length % 64 - 1;
                    }
                    System.arraycopy(buffer, startPos, respData.resData, i2 * 63, length);
                    ++i2;
                }
            } else {
                return;
            }
        }
    }

    public boolean findUsbHidDevice(IPermissionListener listner) {
        if (IDT_Device.getUSBBypass()) {
            this.m_recListener.connectToDevice();
            return true;
        }
        if (this.mManager == null) {
            this.mManager = (UsbManager)this.ctx.getSystemService("usb");
        }
        this.usbDevice = null;
        HashMap deviceList = this.mManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            if (device.getVendorId() != this.VID || device.getProductId() != this.PID) continue;
            if (!this.mManager.hasPermission(device)) {
                listner.onPermissionDenied(device);
            }
            this.usbDevice = device;
            break;
        }
        if (this.usbDevice == null) {
            return false;
        }
        this.usbInterface = this.usbDevice.getInterface(this.usbDevice.getInterfaceCount() - 1);
        this.connection = this.mManager.openDevice(this.usbDevice);
        if (this.connection == null) {
            return false;
        }
        this.connection.claimInterface(this.usbInterface, true);
        int i = 0;
        while (i < this.usbInterface.getEndpointCount()) {
            if (this.usbInterface.getEndpoint(i).getType() == 3) {
                if (this.usbInterface.getEndpoint(i).getDirection() == 128) {
                    this.epIn = this.usbInterface.getEndpoint(i);
                } else if (this.usbInterface.getEndpoint(i).getDirection() == 0) {
                    this.epOut = this.usbInterface.getEndpoint(i);
                }
            }
            ++i;
        }
        if (this.epIn == null) {
            return false;
        }
        this.toClose = false;
        return true;
    }

    public byte[] PAT_wakeup_sendCommand(byte[] command, int timeout) {
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (command != null) {
            this.write(command, command.length);
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] sendCommand(byte[] command, int timeout) {
        block36: {
            block35: {
                if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
                    UMLog.i("SDK::USB Controller", "Failed to send a command: ");
                    this.waitingForResult = false;
                    return null;
                }
                try {
                    Thread.sleep(UsbController.preSendDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                responseData = null;
                buff = new byte[4096];
                res = 0;
                if (command != null && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                    this.write(command, command.length);
                }
                endTime = startTime = System.currentTimeMillis();
                if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) break block35;
                try {
                    Thread.sleep(UsbController.postSendDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                while ((double)(endTime - startTime) <= Common.commandTime * 1000.0) {
                    if (IDT_Device.getCancelTransaction()) {
                        responseData = null;
                        this.waitingForResult = false;
                        return responseData;
                    }
                    res = (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) && IDT_Device.isAutoPollOn != false ? this.read_KioskIII(buff) : this.read(buff);
                    if (res > 0) {
                        if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || res <= 12 || buff[10] == command[11]) break;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        endTime = System.currentTimeMillis();
                        res = 0;
                        continue;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    endTime = System.currentTimeMillis();
                }
                if ((double)(endTime - startTime) > Common.commandTime * 1000.0) {
                    responseData = null;
                    responseData = new byte[]{0};
                    return responseData;
                }
                break block36;
            }
            if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) ** GOTO lbl110
            if (this.connection == null) {
                UMLog.i("SDK::USB Controller", "Failed to send a command: ");
                return null;
            }
            if (this.commandThread != null && this.commandThread.isAlive()) {
                UMLog.i("SDK::USB Controller", "Failed to send a command: ");
                return null;
            }
            this.cmdID = timeout;
            if (command.length <= 8) {
                ret = this.connection.controlTransfer(33, 9, 768, 0, command, command.length, 0);
            } else {
                times = command.length / 8;
                if (command.length % 8 != 0) {
                    ++times;
                }
                i = 0;
                while (i < times) {
                    temp = new byte[8];
                    len = i == times - 1 ? command.length - i * 8 : 8;
                    System.arraycopy(command, i * 8, temp, 0, len);
                    ret = this.connection.controlTransfer(33, 9, 768, 0, temp, len, 0);
                    ++i;
                }
            }
            if (this.cmdID == 6) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            } else {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            this.commandThread = new CommandDataReceiver();
            this.waitingForResult = true;
            this.cmdBufferRet = "";
            this.dataCount = 0;
            this.previousCmdBuffer = null;
            this.commandThread.start();
            while (this.waitingForResult) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException var11_18) {
                    // empty catch block
                }
            }
            if (this.secureMagBuf != null && this.secureMagBuf.length > 0) {
                responseData = new byte[this.secureMagBuf.length];
                System.arraycopy(this.secureMagBuf, 0, responseData, 0, this.secureMagBuf.length);
            }
            return responseData;
            while ((res = this.read(buff)) <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                endTime = System.currentTimeMillis();
lbl110:
                // 2 sources

                if ((double)(endTime - startTime) <= Common.commandTime * 1000.0) continue;
            }
            if ((double)(endTime - startTime) > Common.commandTime * 1000.0 && (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA)) {
                v0 = new byte[3];
                v0[0] = 21;
                v0[1] = -127;
                responseData = v0;
                return responseData;
            }
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**getResponse**", Common.base16Encode(responseData));
            this._msg.usb_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        UMLog.i("**getResponse**", "NULL");
        this.waitingForResult = false;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] sendCommandFw(byte[] command, int timeout) {
        block38: {
            block37: {
                if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
                    UMLog.i("SDK::USB Controller", "Failed to send a command: ");
                    this.waitingForResult = false;
                    return null;
                }
                try {
                    Thread.sleep(UsbController.preSendDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                responseData = null;
                buff = new byte[4096];
                res = 0;
                if (command != null && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) {
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB) {
                        this.write_fw(command, command.length);
                    } else {
                        this.write(command, command.length);
                    }
                }
                endTime = startTime = System.currentTimeMillis();
                if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VENDI && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) break block37;
                try {
                    Thread.sleep(UsbController.postSendDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                while ((double)(endTime - startTime) <= Common.commandTime * 1000.0) {
                    if (IDT_Device.getCancelTransaction()) {
                        responseData = null;
                        this.waitingForResult = false;
                        return responseData;
                    }
                    res = (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI) && IDT_Device.isAutoPollOn != false ? this.read_KioskIII(buff) : this.read(buff);
                    if (res > 0) {
                        if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || res <= 12 || buff[10] == command[11]) break;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        endTime = System.currentTimeMillis();
                        res = 0;
                        continue;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    endTime = System.currentTimeMillis();
                }
                if ((double)(endTime - startTime) > Common.commandTime * 1000.0) {
                    responseData = null;
                    responseData = new byte[]{0};
                    return responseData;
                }
                break block38;
            }
            if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) ** GOTO lbl114
            if (this.connection == null) {
                UMLog.i("SDK::USB Controller", "Failed to send a command: ");
                return null;
            }
            if (this.commandThread != null && this.commandThread.isAlive()) {
                UMLog.i("SDK::USB Controller", "Failed to send a command: ");
                return null;
            }
            this.cmdID = timeout;
            if (command.length <= 8) {
                ret = this.connection.controlTransfer(33, 9, 768, 0, command, command.length, 0);
            } else {
                times = command.length / 8;
                if (command.length % 8 != 0) {
                    ++times;
                }
                i = 0;
                while (i < times) {
                    temp = new byte[8];
                    len = i == times - 1 ? command.length - i * 8 : 8;
                    System.arraycopy(command, i * 8, temp, 0, len);
                    ret = this.connection.controlTransfer(33, 9, 768, 0, temp, len, 0);
                    ++i;
                }
            }
            if (this.cmdID == 6) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            } else {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            this.commandThread = new CommandDataReceiver();
            this.waitingForResult = true;
            this.cmdBufferRet = "";
            this.dataCount = 0;
            this.previousCmdBuffer = null;
            this.commandThread.start();
            while (this.waitingForResult) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException var11_18) {
                    // empty catch block
                }
            }
            if (this.secureMagBuf != null && this.secureMagBuf.length > 0) {
                responseData = new byte[this.secureMagBuf.length];
                System.arraycopy(this.secureMagBuf, 0, responseData, 0, this.secureMagBuf.length);
            }
            return responseData;
            while ((res = this.read(buff)) <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                endTime = System.currentTimeMillis();
lbl114:
                // 2 sources

                if ((double)(endTime - startTime) <= Common.commandTime * 1000.0) continue;
            }
            if ((double)(endTime - startTime) > Common.commandTime * 1000.0 && (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA)) {
                v0 = new byte[3];
                v0[0] = 21;
                v0[1] = -127;
                responseData = v0;
                return responseData;
            }
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**getResponse**", Common.base16Encode(responseData));
            this._msg.usb_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        UMLog.i("**getResponse**", "NULL");
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandOnly(byte[] command, int timeout) {
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(preSendDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (command != null) {
            this.write(command, command.length);
        }
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandForRKI(byte[] command, int timeout) {
        long startTime;
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[1024];
        int res = 0;
        if (command != null) {
            this.write(command, command.length);
        }
        long endTime = startTime = System.currentTimeMillis();
        while ((double)(endTime - startTime) <= Common.commandTime * 1000.0) {
            res = this.readForRKI(buff);
            if (res > 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            endTime = System.currentTimeMillis();
        }
        if ((double)(endTime - startTime) > Common.commandTime * 1000.0 && (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA)) {
            byte[] byArray = new byte[3];
            byArray[0] = 21;
            byArray[1] = -127;
            responseData = byArray;
            return responseData;
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            UMLog.i("**getResponse**", Common.base16Encode(responseData));
            this._msg.usb_onReceiveMsgGetResponse(responseData);
            return responseData;
        }
        this.waitingForResult = false;
        return null;
    }

    public byte[] sendCommandFw(byte[] command) {
        if (this.connection == null && !IDT_Device.getUSBBypass() || this.waitingForResult) {
            UMLog.i(TAG, "Failed to send a command: ");
            this.waitingForResult = false;
            return null;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] responseData = null;
        byte[] buff = new byte[4096];
        int res = 0;
        this.write(command, command.length);
        int i = 0;
        while (i < 5) {
            res = this.read(buff);
            if (res > 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (res > 0) {
            responseData = null;
            responseData = new byte[res];
            System.arraycopy(buff, 0, responseData, 0, res);
            this.waitingForResult = false;
            return responseData;
        }
        this.waitingForResult = false;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int read(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        int i = 0;
        int j = 0;
        int totalLen = 0;
        int dataLen = 0;
        int res = 0;
        Arrays.fill(this.temp, (byte)0);
        byte[] tmp = new byte[64];
        int count = 0;
        int frameCount = 0;
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            while (res != -1) {
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epIn, tmp, 64, 300);
                this.waitingForBulkTransfer = false;
                if (res != 64) continue;
                if (count > 4096) break;
                System.arraycopy(tmp, 0, this.temp, count, 64);
                if (count == 0) {
                    dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                }
                if (dataLen + 16 + ++frameCount <= (count += 64)) break;
            }
            if (Common.isP2()) {
                dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
                if (frameCount > 0) {
                    totalLen = 14 + dataLen + 2;
                }
                if (frameCount < 1) return totalLen;
                int k = 0;
                while (k < frameCount) {
                    if (frameCount == 1) {
                        boolean allZeros = true;
                        int l = 0;
                        while (l < 64) {
                            if (this.temp[l] != 0) {
                                allZeros = false;
                            }
                            ++l;
                        }
                        if (allZeros) {
                            return 0;
                        }
                    }
                    if (k == frameCount - 1) {
                        if (totalLen > 4096) {
                            return 0;
                        }
                        System.arraycopy(this.temp, 1 + 64 * k, data, k * 63, totalLen - k * 63);
                    } else {
                        System.arraycopy(this.temp, 1 + 64 * k, data, k * 63, 63);
                    }
                    ++k;
                }
                return totalLen;
            }
            if (frameCount == 1) {
                totalLen = 16;
                System.arraycopy(this.temp, 1, data, 0, 16);
                return totalLen;
            }
            if (frameCount <= true) return totalLen;
            dataLen = (this.temp[13] & 0xFF) << 8 | this.temp[14] & 0xFF;
            totalLen = 16 + dataLen;
            System.arraycopy(this.temp, 1, data, 0, 14);
            int remainingDataLen = dataLen + 2;
            int index = 14;
            if (this.temp[74] != 68) return totalLen;
            if (remainingDataLen <= 53) {
                System.arraycopy(this.temp, 75, data, index, remainingDataLen);
                return totalLen;
            }
            System.arraycopy(this.temp, 75, data, index, 53);
            remainingDataLen -= 53;
            index += 53;
            int k = 2;
            while (k < frameCount) {
                if (63 - remainingDataLen >= 0) {
                    System.arraycopy(this.temp, 1 + 64 * k, data, index, remainingDataLen);
                    return totalLen;
                }
                System.arraycopy(this.temp, 1 + 64 * k, data, index, 63);
                remainingDataLen -= 63;
                index += 63;
                ++k;
            }
            return totalLen;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            while (res != -1) {
                Arrays.fill(tmp, (byte)0);
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epIn, tmp, 64, 1000);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB READ**", "Read res=" + res);
                if (res != 64) continue;
                System.arraycopy(tmp, 0, this.temp, count, 64);
                if (count == 0 && this.temp[1] == 2) {
                    dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
                }
                if (dataLen + 6 + ++frameCount <= (count += 64)) break;
            }
            if (count <= 0) return 0;
            if (this.temp[1] == 2) {
                totalLen = this.temp[0] & 0xFF;
                dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
                if (totalLen == dataLen + 6 && totalLen < 64) {
                    i = 0;
                    while (i < totalLen + 1) {
                        data[i] = this.temp[i + 1];
                        ++i;
                    }
                    return totalLen;
                }
                if (totalLen != 191) return 0;
                j = 0;
                i = 0;
                while (i + j < 1024) {
                    if ((i + j) % 64 == 0) {
                        ++j;
                    }
                    data[i] = this.temp[i + j];
                    ++i;
                }
                return dataLen + 6;
            }
            count = 0;
            while (this.temp[count] == -65) {
                System.arraycopy(this.temp, count + 1, data, totalLen, 63);
                totalLen += 63;
                count += 64;
            }
            System.arraycopy(this.temp, count + 1, data, totalLen, this.temp[count]);
            return totalLen += this.temp[count];
        }
        if (this.toClose) {
            return 0;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(this.epIn, this.temp, 1024, 2300);
        this.waitingForBulkTransfer = false;
        if (res <= 0) return 0;
        if (this.temp[1] != 2) return 0;
        totalLen = this.temp[0] & 0xFF;
        dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
        if (totalLen == dataLen + 6 && totalLen < 64) {
            i = 0;
            while (i < totalLen + 1) {
                data[i] = this.temp[i + 1];
                ++i;
            }
            return totalLen;
        }
        if (totalLen != 191) return 0;
        j = 0;
        i = 0;
        while (i + j < 1024) {
            if ((i + j) % 64 == 0) {
                ++j;
            }
            data[i] = this.temp[i + j];
            ++i;
        }
        return dataLen + 6;
    }

    private int read_KioskIII(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        int res = 0;
        Arrays.fill(this.temp, (byte)0);
        byte[] tmp = new byte[64];
        int count = 0;
        while (res != -1) {
            if (this.toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            res = this.connection.bulkTransfer(this.epIn, tmp, 64, 300);
            this.waitingForBulkTransfer = false;
            if (res == 64) {
                System.arraycopy(tmp, 1, data, count, 63);
                count += 63;
                continue;
            }
            if (res == -1) break;
            if (res == 0 || res <= 0) continue;
            System.arraycopy(tmp, 1, data, count, res);
            count += res - 1;
        }
        while (count - 1 >= 0 && data[count - 1] == 0) {
            --count;
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readForRKI(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        int i = 0;
        int j = 0;
        int totalLen = 0;
        int dataLen = 0;
        int res = 0;
        Arrays.fill(this.temp, (byte)0);
        byte[] tmp = new byte[64];
        int count = 0;
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            while (res != -1) {
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epIn, tmp, 64, 300);
                this.waitingForBulkTransfer = false;
                if (tmp != null && tmp[1] == 2) break;
            }
            dataLen = (tmp[2] & 0xFF) + (tmp[3] & 0xFF) * 256;
            totalLen = dataLen + 6;
            i = 0;
            while (i < totalLen) {
                data[i] = tmp[i + 1];
                ++i;
            }
            return totalLen;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            while (res != -1) {
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epIn, tmp, 64, 300);
                this.waitingForBulkTransfer = false;
                if (res == 64) {
                    System.arraycopy(tmp, 0, this.temp, count, 64);
                    count += 64;
                    continue;
                }
                if (res == 0 && count > 0) break;
            }
            if (count <= 0) return 0;
            if (this.temp[1] == 2) {
                totalLen = this.temp[0] & 0xFF;
                dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
                if (totalLen == dataLen + 6 && totalLen < 64) {
                    i = 0;
                    while (i < totalLen + 1) {
                        data[i] = this.temp[i + 1];
                        ++i;
                    }
                    return totalLen;
                }
                if (totalLen != 191) return 0;
                j = 0;
                i = 0;
                while (i + j < 1024) {
                    if ((i + j) % 64 == 0) {
                        ++j;
                    }
                    data[i] = this.temp[i + j];
                    ++i;
                }
                return dataLen + 6;
            }
            count = 0;
            while (this.temp[count] == -65) {
                System.arraycopy(this.temp, count + 1, data, totalLen, 63);
                totalLen += 63;
                count += 64;
            }
            System.arraycopy(this.temp, count + 1, data, totalLen, this.temp[count]);
            return totalLen += this.temp[count];
        }
        if (this.toClose) {
            return 0;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(this.epIn, this.temp, 1024, 300);
        this.waitingForBulkTransfer = false;
        if (res <= 0 || this.temp[1] != 2) return 0;
        totalLen = this.temp[0] & 0xFF;
        dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256;
        if (totalLen == dataLen + 6 && totalLen < 64) {
            i = 0;
            while (i < totalLen + 1) {
                data[i] = this.temp[i + 1];
                ++i;
            }
            return totalLen;
        }
        if (totalLen != 191) return 0;
        j = 0;
        i = 0;
        while (i + j < 1024) {
            if ((i + j) % 64 == 0) {
                ++j;
            }
            data[i] = this.temp[i + j];
            ++i;
        }
        return dataLen + 6;
    }

    private int _readMessage(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        int dataLen = 0;
        int res = 1;
        byte[] tmp = new byte[64];
        int index = 0;
        if (this.toClose) {
            return 0;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(this.epIn, tmp, 64, 300);
        this.waitingForBulkTransfer = false;
        if (res > 0) {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                dataLen = (tmp[13] & 0xFF) << 8 | tmp[14] & 0xFF;
                if ((dataLen += 16) <= 63) {
                    System.arraycopy(tmp, 1, data, index, dataLen);
                } else {
                    System.arraycopy(tmp, 1, data, index, 63);
                    index = 63;
                    while (dataLen - index > 63) {
                        if (this.toClose) {
                            return 0;
                        }
                        this.waitingForBulkTransfer = true;
                        res = this.connection.bulkTransfer(this.epIn, tmp, 64, 300);
                        this.waitingForBulkTransfer = false;
                        if (index + 63 > data.length) {
                            return 0;
                        }
                        System.arraycopy(tmp, 1, data, index, 63);
                        index += 63;
                    }
                    if (this.toClose) {
                        return 0;
                    }
                    this.waitingForBulkTransfer = true;
                    res = this.connection.bulkTransfer(this.epIn, tmp, 64, 300);
                    this.waitingForBulkTransfer = false;
                    if (dataLen > data.length) {
                        return 0;
                    }
                    System.arraycopy(tmp, 1, data, index, dataLen - index);
                }
            } else {
                dataLen = (tmp[2] & 0xFF | (tmp[3] & 0xFF) << 8) + 6;
                if (tmp[0] == -65) {
                    System.arraycopy(tmp, 1, data, index, 63);
                    index += 63;
                } else {
                    if (index + dataLen > data.length) {
                        return 0;
                    }
                    System.arraycopy(tmp, 1, data, index, dataLen);
                    index += dataLen;
                }
                while (index < dataLen) {
                    if (this.toClose) {
                        return 0;
                    }
                    this.waitingForBulkTransfer = true;
                    res = this.connection.bulkTransfer(this.epIn, tmp, 64, 300);
                    this.waitingForBulkTransfer = false;
                    if (tmp[0] == -65) {
                        if (index + 63 > data.length) {
                            return 0;
                        }
                        System.arraycopy(tmp, 1, data, index, 63);
                        index += 63;
                        continue;
                    }
                    if (dataLen > data.length) {
                        return 0;
                    }
                    System.arraycopy(tmp, 1, data, index, dataLen - index);
                    index = dataLen;
                }
            }
        }
        return dataLen;
    }

    public UsbDeviceConnection getConnection() {
        return this.connection;
    }

    public UsbEndpoint getEndpoint() {
        return this.epIn;
    }

    private byte[] trimCommandResponse(byte[] data) {
        if (data[0] != 6 && data[0] != 21) {
            return null;
        }
        if (data.length > 1 && (data[0] == 6 || data[0] == 21) && data[1] != 2) {
            byte[] ret = new byte[]{data[0]};
            return ret;
        }
        int pos = data.length - 1;
        while (pos >= 0) {
            if (data[pos] != 0) break;
            --pos;
        }
        byte[] ret = new byte[pos + 1];
        System.arraycopy(data, 0, ret, 0, pos + 1);
        while (pos >= 0) {
            if (data[pos] == 3) break;
            --pos;
        }
        if (data[pos - 1] == 3) {
            --pos;
        }
        if ((ret[0] == 6 || ret[0] == 21) && ret[1] == 2 && pos > 2) {
            byte[] temp = new byte[pos];
            System.arraycopy(ret, 1, temp, 0, pos);
            byte LRC = Common.getLRC(temp);
            if (LRC == ret[pos + 1]) {
                temp = new byte[pos + 2];
                System.arraycopy(ret, 0, temp, 0, pos + 2);
                return temp;
            }
        }
        return ret;
    }

    private boolean isDataRepeated() {
        if (this.previousCmdBuffer == null) {
            this.previousCmdBuffer = new byte[8];
            System.arraycopy(this.cmdBuffer, 0, this.previousCmdBuffer, 0, 8);
            return false;
        }
        int i = 0;
        while (i < 8) {
            if (this.previousCmdBuffer[i] != this.cmdBuffer[i]) {
                System.arraycopy(this.cmdBuffer, 0, this.previousCmdBuffer, 0, 8);
                return false;
            }
            ++i;
        }
        return true;
    }

    private int readCommandBuffer() {
        if (this.connection == null) {
            return 0;
        }
        return this.connection.controlTransfer(161, 1, 768, 0, this.cmdBuffer, 8, 0);
    }

    private int readBuffer(byte[] buffer) throws Exception {
        if (this.connection != null) {
            return this.connection.bulkTransfer(this.epIn, buffer, buffer.length, 300);
        }
        return 0;
    }

    public int readMSR(byte[] data) {
        if (IDT_Device.getUSBBypass()) {
            return IDT_Device.rVD(data);
        }
        if (this.connection == null) {
            return 0;
        }
        this.temp = new byte[4096];
        int i = 0;
        int j = 0;
        int totalLen = 0;
        int dataLen = 0;
        int res = 0;
        if (this.toClose) {
            return 0;
        }
        this.waitingForBulkTransfer = true;
        res = this.connection.bulkTransfer(this.epIn, this.temp, 4096, 300);
        this.waitingForBulkTransfer = false;
        if (res > 0) {
            if (this.temp[1] == 2 && (totalLen = this.temp[0] & 0xFF) == (dataLen = (this.temp[2] & 0xFF) + (this.temp[3] & 0xFF) * 256) + 6 && totalLen < 64) {
                i = 0;
                while (i < totalLen + 1) {
                    data[i] = this.temp[i + 1];
                    ++i;
                }
                return totalLen;
            }
            totalLen = this.temp[0] & 0xFF;
            dataLen = (this.temp[3] & 0xFF) + (this.temp[4] & 0xFF) * 256;
            if (totalLen < 64) {
                i = 0;
                while (i < totalLen + 1) {
                    data[i] = this.temp[i + 1];
                    ++i;
                }
                return totalLen;
            }
            if (totalLen == 191) {
                dataLen = 0;
                j = 0;
                i = 0;
                while (i + j < 4096) {
                    if ((i + j) % 64 == 0) {
                        totalLen = this.temp[i + j] & 0xFF;
                        if (totalLen == 191) {
                            dataLen += 63;
                        } else {
                            if (totalLen < 64 && totalLen > 0) {
                                dataLen += totalLen;
                                ++j;
                                int k = 0;
                                while (k < totalLen) {
                                    data[i + k] = this.temp[i + j + k];
                                    ++k;
                                }
                                return dataLen;
                            }
                            if (totalLen == 0) break;
                        }
                        ++j;
                    }
                    data[i] = this.temp[i + j];
                    ++i;
                }
                return dataLen;
            }
        }
        return 0;
    }

    public boolean close() {
        if (IDT_Device.getUSBBypass()) {
            return true;
        }
        this.toClose = true;
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (this.waitingForBulkTransfer);
        if (this.epIn != null) {
            this.epIn = null;
        }
        if (this.connection != null) {
            int i = 0;
            boolean res = false;
            i = 0;
            while (i < 3) {
                res = this.connection.releaseInterface(this.usbInterface);
                if (res) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            if (i >= 3) {
                return false;
            }
            this.connection.close();
            this.usbInterface = null;
            this.connection = null;
        }
        System.gc();
        return true;
    }

    public int writeNothing() {
        if (this.connection == null) {
            return 0;
        }
        int res = 0;
        int iii = 0;
        do {
            ++iii;
            if (this.toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            if (IDT_Device.getUSBBypass()) {
                this.m_recListener.usbBypassData(null);
                res = 0;
            } else {
                res = this.connection.bulkTransfer(this.epOut, null, 0, 2300);
            }
            this.waitingForBulkTransfer = false;
            UMLog.i("**USB bulkTransfer**", "write res=" + res);
        } while (res != 0 && iii < 10);
        return res;
    }

    public int write(byte[] command, int length) {
        if (IDT_Device.getUSBBypass()) {
            byte[] temp = null;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                temp = new byte[length - 1];
                System.arraycopy(command, 1, temp, 0, temp.length);
            } else {
                temp = new byte[length];
                System.arraycopy(command, 0, temp, 0, temp.length);
            }
            this.m_recListener.usbBypassData(temp);
            return temp.length;
        }
        if (length <= 0) {
            return 0;
        }
        if (this.connection == null) {
            return 0;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            return this.write_VP8800(command, length);
        }
        int res = 0;
        if (length >= 64) {
            int len = (length - 1) / 63 + 1 + length;
            byte[] com = new byte[len];
            int j = 0;
            int i = 0;
            while (i < len) {
                if (i % 64 == 0) {
                    ++j;
                    com[i] = len - i > 64 ? -65 : (len - i < 64 ? (int)(length % 63) : 63);
                } else {
                    com[i] = command[i - j];
                }
                ++i;
            }
            int iii = 0;
            while (iii * 64 < len) {
                byte[] temp = new byte[64];
                if ((iii + 1) * 64 > len) {
                    System.arraycopy(com, 64 * iii, temp, 0, len - iii * 64);
                } else {
                    System.arraycopy(com, 64 * iii, temp, 0, 64);
                }
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epOut, temp, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                ++iii;
            }
        } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            byte[] com = new byte[64];
            com[0] = (byte)length;
            System.arraycopy(command, 0, com, 1, length);
            int i = length + 1;
            while (i < 64) {
                com[i] = 0;
                ++i;
            }
            int iii = 0;
            do {
                ++iii;
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 2**", "write res=" + res);
            } while (res <= 0 && iii < 10);
        } else {
            byte[] com = new byte[length + 1];
            com[0] = (byte)length;
            System.arraycopy(command, 0, com, 1, length);
            if (this.toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            res = this.connection.bulkTransfer(this.epOut, com, length + 1, 2300);
            this.waitingForBulkTransfer = false;
            UMLog.i("**USB bulkTransfer 3**", "write res=" + res);
        }
        UMLog.i("**USB SEND**", "write res=" + res);
        return res;
    }

    public int write_fw(byte[] command, int length) {
        if (IDT_Device.getUSBBypass()) {
            byte[] temp = null;
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                temp = new byte[length - 1];
                System.arraycopy(command, 1, temp, 0, temp.length);
            } else {
                temp = new byte[length];
                System.arraycopy(command, 0, temp, 0, temp.length);
            }
            this.m_recListener.usbBypassData(temp);
            return temp.length;
        }
        if (length <= 0) {
            return 0;
        }
        if (this.connection == null) {
            return 0;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            return this.write_VP8800(command, length);
        }
        int res = 0;
        if (length >= 64) {
            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
                int len = (length - 1) / 63 + 1 + (length - 1);
                byte[] com = new byte[len];
                int times = len / 64 + 1;
                int i = 0;
                while (i < times) {
                    if (i == times - 1) {
                        com[i * 64] = 4;
                        System.arraycopy(command, 63 * i + 1, com, 64 * i + 1, length - 1 - i * 63);
                    } else if (i == 0) {
                        com[0] = 2;
                        System.arraycopy(command, 1, com, 1, 63);
                    } else {
                        com[i * 64] = 3;
                        System.arraycopy(command, 63 * i + 1, com, 64 * i + 1, 63);
                    }
                    ++i;
                }
                int iii = 0;
                while (iii * 64 < len) {
                    byte[] temp = new byte[64];
                    if ((iii + 1) * 64 > len) {
                        System.arraycopy(com, 64 * iii, temp, 0, len - iii * 64);
                    } else {
                        System.arraycopy(com, 64 * iii, temp, 0, 64);
                    }
                    if (this.toClose) {
                        return 0;
                    }
                    this.waitingForBulkTransfer = true;
                    res = this.connection.bulkTransfer(this.epOut, temp, 64, 2300);
                    this.waitingForBulkTransfer = false;
                    UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                    ++iii;
                }
            } else {
                int len = (length - 1) / 63 + 1 + length;
                byte[] com = new byte[len];
                int j = 0;
                int i = 0;
                while (i < len) {
                    if (i % 64 == 0) {
                        ++j;
                        com[i] = len - i > 64 ? -65 : (len - i < 64 ? (int)(length % 63) : 63);
                    } else {
                        com[i] = command[i - j];
                    }
                    ++i;
                }
                int iii = 0;
                while (iii * 64 < len) {
                    byte[] temp = new byte[64];
                    if ((iii + 1) * 64 > len) {
                        System.arraycopy(com, 64 * iii, temp, 0, len - iii * 64);
                    } else {
                        System.arraycopy(com, 64 * iii, temp, 0, 64);
                    }
                    if (this.toClose) {
                        return 0;
                    }
                    this.waitingForBulkTransfer = true;
                    res = this.connection.bulkTransfer(this.epOut, temp, 64, 2300);
                    this.waitingForBulkTransfer = false;
                    UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                    ++iii;
                }
                do {
                    res = this.connection.bulkTransfer(this.epOut, com, 64, 2300);
                    UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                } while (res <= 0 && ++iii < 10);
            }
        } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_KIOSK_III || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VENDI || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP2000 || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) {
            byte[] com = new byte[64];
            com[0] = 1;
            System.arraycopy(command, 0, com, 1, length);
            int i = length + 1;
            while (i < 64) {
                com[i] = 0;
                ++i;
            }
            int iii = 0;
            do {
                ++iii;
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 2**", "write res=" + res);
            } while (res <= 0 && iii < 10);
        } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
            byte[] com = new byte[64];
            com[0] = (byte)length;
            System.arraycopy(command, 0, com, 1, length);
            int i = length + 1;
            while (i < 64) {
                com[i] = 0;
                ++i;
            }
            int iii = 0;
            do {
                ++iii;
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 2**", "write res=" + res);
            } while (res <= 0 && iii < 10);
        } else {
            byte[] com = new byte[length + 1];
            com[0] = (byte)length;
            System.arraycopy(command, 0, com, 1, length);
            if (this.toClose) {
                return 0;
            }
            this.waitingForBulkTransfer = true;
            res = this.connection.bulkTransfer(this.epOut, com, length + 1, 2300);
            this.waitingForBulkTransfer = false;
            UMLog.i("**USB bulkTransfer 3**", "write res=" + res);
        }
        return res;
    }

    public int write_VP8800(byte[] command, int length) {
        int res = 0;
        byte[] com = new byte[64];
        int index = 0;
        if (length > 63) {
            int count = length / 63;
            if (length % 63 != 0) {
                ++count;
            }
            int j = 0;
            while (j < count) {
                int i = 1;
                while (i < 64) {
                    com[i] = 0;
                    ++i;
                }
                com[0] = j == 0 ? 2 : (j == count - 1 ? 4 : 3);
                System.arraycopy(command, index, com, 1, length - index > 63 ? 63 : length - index);
                index += 63;
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 1**", "write res=" + res);
                ++j;
            }
        } else {
            com[0] = 1;
            System.arraycopy(command, 0, com, 1, length);
            int i = length + 1;
            while (i < 64) {
                com[i] = 0;
                ++i;
            }
            int iii = 0;
            do {
                ++iii;
                if (this.toClose) {
                    return 0;
                }
                this.waitingForBulkTransfer = true;
                res = this.connection.bulkTransfer(this.epOut, com, 64, 2300);
                this.waitingForBulkTransfer = false;
                UMLog.i("**USB bulkTransfer 2**", "write res=" + res);
            } while (res <= 0 && iii < 10);
        }
        UMLog.i("**USB SEND**", "write res=" + res);
        return res;
    }

    static /* synthetic */ void access$16(UsbController usbController, byte[] byArray) {
        usbController.swipeBuffer = byArray;
    }

    static /* synthetic */ byte[] access$17(UsbController usbController) {
        return usbController.swipeBuffer;
    }

    static /* synthetic */ int access$18(UsbController usbController, byte[] byArray) throws Exception {
        return usbController.readBuffer(byArray);
    }

    static /* synthetic */ int access$19(UsbController usbController) {
        return usbController.swipeCount;
    }

    static /* synthetic */ int access$20(UsbController usbController) {
        return usbController.swipeTimeoutSec;
    }

    static /* synthetic */ byte[] access$21(UsbController usbController) {
        return usbController.temp;
    }

    static /* synthetic */ void access$22(UsbController usbController, int n) {
        usbController.swipeCount = n;
    }

    private class CheckDeviceThread
    extends Thread {
        boolean res = false;

        private CheckDeviceThread() {
        }

        public void run() {
            try {
                CheckDeviceThread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (!this.res) {
                if (UsbController.this.mManager == null) break;
                this.res = UsbController.this.initWithThread();
                try {
                    CheckDeviceThread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class CommandDataReceiver
    extends Thread {
        private CommandDataReceiver() {
        }

        public void run() {
            while (UsbController.this.dataCount < 80) {
                try {
                    CommandDataReceiver.sleep(30L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                int length = UsbController.this.readCommandBuffer();
                UMLog.i(UsbController.TAG, "Command response length received: " + length);
                if (length > 0) {
                    if (UsbController.this.isDataRepeated()) {
                        byte[] ret = UsbController.this.trimCommandResponse(Common.getBytesFromHexString(UsbController.this.cmdBufferRet));
                        if (ret == null) {
                            UMLog.i(UsbController.TAG, "Wrong command response received: " + UsbController.this.cmdBufferRet);
                            UsbController.this._msg.usb_onReceiveMsgFailureInfo(102);
                            UsbController.this.secureMagBuf = null;
                            break;
                        }
                        UMLog.i(UsbController.TAG, "Command response received: " + Common.getHexStringFromBytes(ret));
                        UsbController.this.secureMagBuf = new byte[ret.length];
                        System.arraycopy(ret, 0, UsbController.this.secureMagBuf, 0, ret.length);
                        break;
                    }
                    UsbController usbController = UsbController.this;
                    usbController.cmdBufferRet = String.valueOf(usbController.cmdBufferRet) + Common.getHexStringFromBytes(UsbController.this.cmdBuffer);
                } else if (UsbController.this.cmdBufferRet.length() >= 16) {
                    byte[] ret = UsbController.this.trimCommandResponse(Common.getBytesFromHexString(UsbController.this.cmdBufferRet));
                    if (ret == null) {
                        UMLog.i(UsbController.TAG, "Wrong command response received: " + UsbController.this.cmdBufferRet);
                        UsbController.this.secureMagBuf = null;
                        break;
                    }
                    UMLog.i(UsbController.TAG, "Command response received: " + Common.getHexStringFromBytes(ret));
                    UsbController.this.secureMagBuf = new byte[ret.length];
                    System.arraycopy(ret, 0, UsbController.this.secureMagBuf, 0, ret.length);
                    break;
                }
                UsbController usbController = UsbController.this;
                usbController.dataCount = usbController.dataCount + 1;
            }
            if (UsbController.this.dataCount >= 80) {
                UsbController.this.dataCount = 0;
                UsbController.this.secureMagBuf = new byte[1];
                ((UsbController)UsbController.this).secureMagBuf[0] = 0;
            }
            UsbController.this.waitingForResult = false;
        }
    }

    private static interface IPermissionListener {
        public void onPermissionDenied(UsbDevice var1);
    }

    private class PermissionReceiver
    extends BroadcastReceiver {
        private final IPermissionListener mPermissionListener;

        public PermissionReceiver(IPermissionListener permissionListener) {
            this.mPermissionListener = permissionListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals(UsbController.ACTION_USB_PERMISSION)) {
                PermissionReceiver permissionReceiver = this;
                synchronized (permissionReceiver) {
                    UMLog.i(UsbController.TAG, "ACTION_USB_PERMISSION received, asking permission to user");
                    UsbDevice dev = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        if (!IDT_Device.getUSBBypass()) {
                            UMLog.i(UsbController.TAG, "User granted permission");
                            UsbController.this._usbMsg.onDeviceAttached();
                        }
                    } else {
                        UMLog.i(UsbController.TAG, "User denied permission");
                        this.mPermissionListener.onPermissionDenied(dev);
                    }
                }
            }
        }
    }

    private class SwipeDataReceiver
    extends Thread {
        private boolean swipeCancelled = false;

        private SwipeDataReceiver() {
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block23: {
                if (Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_SECUREMAG_KB) ** GOTO lbl84
                while (!this.swipeCancelled) {
                    try {
                        UsbController.access$16(UsbController.this, new byte[1024]);
                        length = UsbController.access$18(UsbController.this, UsbController.access$17(UsbController.this));
                        if (length <= 0) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        ret = this.parseCardData(UsbController.access$17(UsbController.this));
                        if (ret == null || ret.length <= 0) continue;
                        if (ret[0] == 2 && ret[ret.length - 1] == 3) {
                            if (this.checkLRCAndChecksum(ret)) {
                                UMLog.i("SDK::USB Controller", "Card data received: " + Common.getHexStringFromBytes(ret));
                                UsbController.access$0(UsbController.this).onDeviceMSRData(ret);
                                continue;
                            }
                            UMLog.e("SDK::USB Controller", "Card data error: " + Common.getHexStringFromBytes(ret));
                            UsbController.access$3(UsbController.this).usb_onReceiveMsgFailureInfo(103);
                            continue;
                        }
                        if (ret[0] == 0 && ret[ret.length - 1] == 13) {
                            UMLog.i("SDK::USB Controller", "Card data received: clean text cannot shown shown in Log");
                            UsbController.access$0(UsbController.this).onDeviceMSRData(ret);
                            continue;
                        }
                        UMLog.i("SDK::USB Controller", "Filtered non-MSR data: " + Common.getHexStringFromBytes(ret));
                    }
                    catch (Exception e) {
                        UMLog.e("SDK::USB Controller", "Exception caught: " + e.getMessage().toString());
                    }
                }
                UsbController.access$15(UsbController.this, false);
                break block23;
lbl-1000:
                // 1 sources

                {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_AUGUSTA || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
                        v0 = new byte[11];
                        v0[0] = 2;
                        v0[1] = 5;
                        v0[3] = 115;
                        v0[4] = 70;
                        v0[5] = 81;
                        v0[6] = 1;
                        v0[7] = 48;
                        v0[8] = 85;
                        v0[9] = 59;
                        v0[10] = 3;
                        cmd = v0;
                        cardData = UsbController.this.sendCommand(cmd, 1);
                        if (cardData != null && cardData.length > 3 && cardData[3] != 21) {
                            this.swipeCancelled = true;
                            card = new IDTMSRData();
                            Common.Response.parseCardDataAugusta(cardData, card);
                            UMLog.i("SDK::USB Controller", "got: " + Common.getByteArrDesc(cardData));
                            UsbController.access$3(UsbController.this).usb_onReceiveMsgCardData(card);
                            break;
                        }
                    } else {
                        length = UsbController.this.readMSR(UsbController.access$17(UsbController.this));
                        if (length > 0) {
                            this.swipeCancelled = true;
                            card = new IDTMSRData();
                            cardData = new byte[length];
                            System.arraycopy(UsbController.access$17(UsbController.this), 0, cardData, 0, length);
                            if (cardData[0] == 2 && (cardData[3] == -128 || cardData[3] == -127 || cardData[3] == -125 || cardData[3] == -124 || cardData[3] == -123 || cardData[3] == -122 || cardData[3] == -64)) {
                                Common.Response.parseCardData(cardData, card, 0);
                            } else if (cardData[1] == 2 && (UsbController.access$21(UsbController.this)[4] == -128 || cardData[4] == -127 || cardData[4] == -125 || cardData[4] == -124 || cardData[4] == -123 || cardData[4] == -122 || cardData[4] == -64)) {
                                Common.Response.parseCardDataUniPay(cardData, card);
                            } else {
                                Common.Response.parseCardClearData(cardData, card);
                            }
                            UMLog.i("SDK::USB Controller", "got: " + Common.getByteArrDesc(UsbController.access$17(UsbController.this)));
                            UsbController.access$3(UsbController.this).usb_onReceiveMsgCardData(card);
                            break;
                        }
                    }
                    v1 = UsbController.this;
                    UsbController.access$22(v1, UsbController.access$19(v1) + 1);
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
lbl84:
                    // 3 sources

                    ** while (UsbController.access$19((UsbController)UsbController.this) < UsbController.access$20((UsbController)UsbController.this) && !this.swipeCancelled)
                }
lbl85:
                // 3 sources

                if (UsbController.access$19(UsbController.this) >= UsbController.access$20(UsbController.this)) {
                    this.close();
                    UsbController.access$3(UsbController.this).usb_onReceiveMsgSwipeTimeout();
                }
                UsbController.access$15(UsbController.this, false);
                IDT_Device.isCommandRunning = false;
            }
        }

        public void close() {
            this.swipeCancelled = true;
        }

        private byte[] parseCardData(byte[] data) {
            int pos = data.length - 1;
            while (pos >= 0) {
                if (data[pos] != 0) break;
                --pos;
            }
            if (pos == 0) {
                return null;
            }
            byte[] ret = new byte[pos + 1];
            System.arraycopy(data, 0, ret, 0, pos + 1);
            return ret;
        }

        private boolean checkLRCAndChecksum(byte[] data) {
            return data[data.length - 3] == this.calculateLRC(data) && data[data.length - 2] == this.calculateCheckSum(data);
        }

        private byte calculateLRC(byte[] data) {
            int result = 0;
            int i = 3;
            while (i < data.length - 3) {
                result = (byte)(result ^ data[i]);
                ++i;
            }
            return (byte)(0xFF & result);
        }

        private byte calculateCheckSum(byte[] data) {
            int result = 0;
            int i = 3;
            while (i < data.length - 3) {
                result = (byte)(result + data[i]);
                ++i;
            }
            return (byte)(0xFF & result);
        }
    }

    private class listenForDataOnThread
    extends Thread {
        public boolean isRunning = true;

        private listenForDataOnThread() {
        }

        public void run() {
            byte[] tmp = new byte[4096];
            while (this.isRunning) {
                byte[] data;
                if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_MINISMART_II) {
                    if (!IDT_Device.isNotificationOn || IDT_Device.isCommandRunning) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    IDT_Device.isCheckingNotification = true;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    int length = UsbController.this._readMessage(tmp);
                    if (length > 0) {
                        data = new byte[length - 6];
                        System.arraycopy(tmp, 3, data, 0, length - 6);
                        UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                        UsbController.this._msg.usb_onReceiveMsgGetICCNotifyInfo(data);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    IDT_Device.isCheckingNotification = false;
                    continue;
                }
                if (!IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || IDT_Device.isCommandRunning || Common.getBootLoaderMode()) {
                    IDTMSRData card;
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800) continue;
                    try {
                        Thread.sleep(950L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isCommandRunning) continue;
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT_USB) {
                        if (IDT_Device.isMonitorCtlsData) {
                            card = new IDTMSRData();
                            byte[] command = Common.getByteArray("105669564F7465636832000340000096E2");
                            byte[] data2 = UsbController.this.sendCommand(command, 1);
                            int len = 0;
                            if (data2 != null && data2.length > 13) {
                                len = (data2[12] & 0xFF) * 256 + (data2[13] & 0xFF);
                            }
                            if (len > 7) {
                                Common.parseCardData3in1(data2, card);
                                UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data2));
                                UsbController.this._msg.usb_onReceiveMsgCardData(card);
                                continue;
                            }
                            card.result = 61092;
                            UsbController.this._msg.usb_onReceiveMsgCardData(card);
                            continue;
                        }
                        card = new IDTMSRData();
                        card.result = 61092;
                        UsbController.this._msg.usb_onReceiveMsgCardData(card);
                        continue;
                    }
                    card = new IDTMSRData();
                    card.result = 61092;
                    UsbController.this._msg.usb_onReceiveMsgCardData(card);
                    continue;
                }
                IDT_Device.isCheckingNotification = true;
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int length = UsbController.this.read_KioskIII(tmp);
                if (length > 0) {
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB) {
                        if (length > 12 && tmp[10] == 97 && tmp[11] == 1) {
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                    } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_USB) {
                        IDTMSRData card;
                        if (length > 12 && tmp[10] == 2 && tmp[11] == -96) {
                            card = new IDTMSRData();
                            card.result = 61088;
                            UsbController.this._msg.usb_onReceiveMsgCardData(card);
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (length > 12 && tmp[10] == -18 && tmp[11] == -16) {
                            card = new IDTMSRData();
                            card.result = 61168;
                            UsbController.this._msg.usb_onReceiveMsgCardData(card);
                            try {
                                Thread.sleep(30L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                    }
                    data = new byte[length];
                    System.arraycopy(tmp, 0, data, 0, length);
                    IDTMSRData card = new IDTMSRData();
                    Common.processCTLSData(data, card);
                    UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                    UsbController.this._msg.usb_onReceiveMsgCardData(card);
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IDT_Device.isCheckingNotification = false;
            }
            UsbController.this.listenThread = null;
        }
    }
}

