/*
 * Decompiled with CFR 0.152.
 */
package com.zeamster.paymentsdk.service;

import com.zeamster.paymentsdk.accountvaults.RouterAccountVaults;
import com.zeamster.paymentsdk.resthandler.RestServiceClient;
import com.zeamster.paymentsdk.routertransaction.RouterTransaction;
import com.zeamster.paymentsdk.service.PaymentMethod;
import com.zeamster.paymentsdk.transaction.ACHTransaction;
import com.zeamster.paymentsdk.transaction.CreditCardTransaction;
import com.zeamster.paymentsdk.transaction.GenericTransaction;
import com.zeamster.paymentsdk.transaction.TransactionAction;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class TransactionService {
    private static final String ROUTER_TRANSACTIONS = "routertransactions";
    private static final String ACCOUNT_VAULT_ID = "account_vault_id";
    private static final String PAYMENT_METHOD = "payment_method";
    private static final String ACCOUNT_NUMBER = "account_number";
    private static final String ACTION = "action";
    private static final String TICKET = "ticket";
    private RestServiceClient restServiceClient;
    private String paymentMethod = "";

    public TransactionService(RestServiceClient restServiceClient) {
        this.restServiceClient = restServiceClient;
    }

    public void processTransaction(TransactionAction transactionAction, HashMap<String, String> payLoadMap, String transactionId) {
        this.setPaymentMethod(payLoadMap);
        payLoadMap.put(ACTION, transactionAction.name().toLowerCase());
        switch (transactionAction) {
            case SALE: {
                this.performSale(payLoadMap);
                break;
            }
            case REFUND: {
                this.performRefund(payLoadMap);
                break;
            }
            case VOID: {
                GenericTransaction genericTransaction = new GenericTransaction(this.restServiceClient);
                genericTransaction.performVoid(transactionId, payLoadMap);
                break;
            }
            case AUTHONLY: {
                this.performAuthOnly(payLoadMap);
                break;
            }
            case AUTHCOMPLETE: {
                CreditCardTransaction ccTransaction = new CreditCardTransaction(this.restServiceClient);
                ccTransaction.performAuthComplete(transactionId, payLoadMap);
                break;
            }
            case AUTHINCREMENT: {
                CreditCardTransaction ccTransaction = new CreditCardTransaction(this.restServiceClient);
                ccTransaction.performAuthIncrement(transactionId, payLoadMap);
                break;
            }
            case FORCE: {
                CreditCardTransaction ccTransaction = new CreditCardTransaction(this.restServiceClient);
                ccTransaction.performForce(transactionId, payLoadMap);
                break;
            }
            case TIPADJUST: {
                GenericTransaction genericTransaction = new GenericTransaction(this.restServiceClient);
                genericTransaction.performTipAdjust(transactionId, payLoadMap);
                break;
            }
            case DEBIT: {
                this.performDebit(payLoadMap);
                break;
            }
            case CREDIT: {
                this.performCredit(payLoadMap);
                break;
            }
            case EDIT: {
                GenericTransaction genericTransaction = new GenericTransaction(this.restServiceClient);
                genericTransaction.performEdit(transactionId, payLoadMap);
                break;
            }
            case AVSONLY: {
                this.performAVSOnly(payLoadMap);
                break;
            }
            case VIEW_TRANSACTION: {
                GenericTransaction genericTransaction = new GenericTransaction(this.restServiceClient);
                genericTransaction.getTransaction(transactionId);
                break;
            }
            case VIEW_TRANSACTIONS_ALL: {
                GenericTransaction genericTransaction = new GenericTransaction(this.restServiceClient);
                genericTransaction.getAllTransactions();
                break;
            }
            case VIEW_TRANSACTIONS_FILTERED: {
                GenericTransaction genericTransaction = new GenericTransaction(this.restServiceClient);
                genericTransaction.getTransactions(payLoadMap);
                break;
            }
            case BININFO: {
                GenericTransaction genericTransaction = new GenericTransaction(this.restServiceClient);
                genericTransaction.getBinInfo(transactionId);
                break;
            }
            case STORE: {
                RouterAccountVaults routerAccountVaults = new RouterAccountVaults(this.restServiceClient);
                routerAccountVaults.store(payLoadMap);
            }
        }
    }

    public void processTransaction(TransactionAction transactionAction, HashMap<String, String> payLoadJson) {
        this.processTransaction(transactionAction, payLoadJson, "");
    }

    private void setPaymentMethod(HashMap<String, String> payLoadMap) {
        try {
            JSONObject payLoadJson = new JSONObject(payLoadMap);
            if (payLoadJson.has(PAYMENT_METHOD) && !payLoadJson.isNull(PAYMENT_METHOD)) {
                this.paymentMethod = payLoadJson.get(PAYMENT_METHOD).toString().trim().toLowerCase();
            }
        }
        catch (JSONException ex) {
            this.restServiceClient.addError(((Object)((Object)ex)).getClass().getName(), ex.getMessage());
        }
    }

    private void performSale(HashMap<String, String> payLoadMap) {
        if (this.restServiceClient.getApiEndpoint() != null && this.restServiceClient.getApiEndpoint().contains(ROUTER_TRANSACTIONS)) {
            RouterTransaction routerTransaction = new RouterTransaction(this.restServiceClient);
            routerTransaction.performSale(payLoadMap);
        } else {
            CreditCardTransaction ccTransaction = new CreditCardTransaction(this.restServiceClient);
            JSONObject payLoadJson = new JSONObject(payLoadMap);
            if (payLoadJson.has(ACCOUNT_VAULT_ID) && !payLoadJson.isNull(ACCOUNT_VAULT_ID)) {
                ccTransaction.performSaleViaVault(payLoadMap);
            } else if (payLoadJson.has(TICKET) && !payLoadJson.isNull(TICKET)) {
                ccTransaction.performSaleViaTicket(payLoadMap);
            } else {
                ccTransaction.performSaleViaCard(payLoadMap);
            }
        }
    }

    private void performRefund(HashMap<String, String> payLoadMap) {
        if (this.restServiceClient.getApiEndpoint() != null && this.restServiceClient.getApiEndpoint().contains(ROUTER_TRANSACTIONS)) {
            RouterTransaction routerTransaction = new RouterTransaction(this.restServiceClient);
            routerTransaction.performRefund(payLoadMap);
        } else if (PaymentMethod.valueOf(this.paymentMethod.toUpperCase()).equals((Object)PaymentMethod.CC)) {
            CreditCardTransaction ccTransaction = new CreditCardTransaction(this.restServiceClient);
            ccTransaction.performRefund(payLoadMap);
        } else {
            ACHTransaction achTransaction = new ACHTransaction(this.restServiceClient);
            achTransaction.performRefund(payLoadMap);
        }
    }

    private void performAuthOnly(HashMap<String, String> payLoadMap) {
        if (this.restServiceClient.getApiEndpoint() != null && this.restServiceClient.getApiEndpoint().contains(ROUTER_TRANSACTIONS)) {
            RouterTransaction routerTransaction = new RouterTransaction(this.restServiceClient);
            routerTransaction.performAuthOnly(payLoadMap);
        } else {
            CreditCardTransaction ccTransaction = new CreditCardTransaction(this.restServiceClient);
            ccTransaction.performAuthOnly(payLoadMap);
        }
    }

    private void performDebit(HashMap<String, String> payLoadMap) {
        ACHTransaction achTransaction = new ACHTransaction(this.restServiceClient);
        JSONObject payLoadJson = new JSONObject(payLoadMap);
        if (payLoadJson.has(ACCOUNT_VAULT_ID) && !payLoadJson.isNull(ACCOUNT_VAULT_ID)) {
            achTransaction.performDebitViaVault(payLoadMap);
        } else {
            achTransaction.performDebitViaAccount(payLoadMap);
        }
    }

    private void performCredit(HashMap<String, String> payLoadMap) {
        ACHTransaction achTransaction = new ACHTransaction(this.restServiceClient);
        JSONObject payLoadJson = new JSONObject(payLoadMap);
        if (payLoadJson.has(ACCOUNT_VAULT_ID) && !payLoadJson.isNull(ACCOUNT_VAULT_ID)) {
            achTransaction.performCreditViaVault(payLoadMap);
        } else {
            achTransaction.performCreditViaAccount(payLoadMap);
        }
    }

    private void performAVSOnly(HashMap<String, String> payLoadMap) {
        if (PaymentMethod.valueOf(this.paymentMethod.toUpperCase()).equals((Object)PaymentMethod.CC)) {
            CreditCardTransaction ccTransaction = new CreditCardTransaction(this.restServiceClient);
            ccTransaction.performAVSOnly(payLoadMap);
        } else {
            ACHTransaction achTransaction = new ACHTransaction(this.restServiceClient);
            achTransaction.performAVSOnly(payLoadMap);
        }
    }
}

