/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;

public class ConnectTask
extends Task {
    private final boolean _connectWithCmd;
    private IDT_Device.TaskExport _taskExport;
    private Common.PUSType _pus;

    public ConnectTask(TaskManager umMan, ReaderCommunication readerCommunication, boolean connectWithCmd, IDT_Device.TaskExport taskExport) {
        super(umMan, readerCommunication);
        this._connectWithCmd = connectWithCmd;
        this._taskExport = taskExport;
    }

    public ConnectTask(TaskManager umMan, ReaderCommunication readerCommunication, Common.PUSType pus) {
        super(umMan, readerCommunication);
        this._connectWithCmd = false;
        this._taskExport = null;
        this._pus = pus;
    }

    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Connect;
    }

    protected void taskCleanup() {
        if (this._ioManager != null) {
            this._ioManager.notifyTaskFinished();
        }
    }

    protected Runnable taskMain() {
        IOManager.RPDResult r;
        if (this._pus != null) {
            UMLog.i(this.TAG, "connected " + this._pus.name);
            if (this._config.getVolumeLevelAdjust() > 1) {
                this._ioManager.setDeviceMediaVolumeToMaxMinusArg(1);
            }
            final Common.PUSType fpus = this._pus;
            return new Runnable(){

                public void run() {
                    if (fpus.readerType != null) {
                        ConnectTask.this._readerCommunication.readerType_set(fpus.readerType);
                    }
                    Common.coverAllBaudRate = false;
                    ConnectTask.this._readerCommunication.cxn_setConnected(ToneType.T_2000Hz);
                    Common.beginTimeEachCmd = Common.getCurrentTime();
                }
            };
        }
        Common.PUSType pus = null;
        Common.beginTimeEachCmd = Common.getCurrentTime();
        int repN = 6;
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNKNOWN) {
            this._taskExport.setReaderType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG);
            this._ioManager.resetPlayer();
        }
        if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            String cancelEMVTransactionCmd = Common.packageCommandForVendi("5669564F7465636832000501000092EF");
            r = this._readerCommunication.sendCommand(Common.getBytesFromHexString(cancelEMVTransactionCmd), 1.5, this, this);
            if (r != null && r.data != null) {
                r.data.clear();
            }
            String passThroughModeOffCmd = Common.packageCommandForVendi("5669564F7465636832002C01000100380D");
            r = this._readerCommunication.sendCommand(Common.getBytesFromHexString(passThroughModeOffCmd), 1.5, this, this);
            IDT_Device.isPassthroughModeOn = false;
            if (r != null && r.data != null) {
                r.data.clear();
            }
        }
        int reps = 1;
        while (reps <= 6) {
            if (reps == 6 && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ && this._taskExport.getReaderType() != ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                UMLog.i(this.TAG, "Connect Task: changing output wave direction");
                this._config.setDirectionOutputWave((short)(this._config.getDirectionOutputWave() != 1 ? 1 : 0));
                this._ioManager.setConfig(this._config);
            }
            if (this._connectWithCmd) {
                UMLog.i(this.TAG, "set baud rate and channel level. baudrate = " + this._config.getBaudRate() + " , level = " + this._config.getShuttleChannel());
                if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
                    UMLog.i(this.TAG, "Try to connect for UNIMAG with " + this._config.getBaudRate() + " baud rate");
                    r = this._readerCommunication.connect(Common.makeSetBaudCommand(this._config), 1.5, this, this);
                } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                    UMLog.i(this.TAG, "Try to connect for UNIJACK with " + this._config.getBaudRate() + " baud rate");
                    r = this._readerCommunication.connect(Common.makeSetBaudCommandForUniJack(this._config), 1.0, this, this);
                } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                    UMLog.i(this.TAG, "Try to connect for VP3300 AJ with " + this._config.getBaudRate() + " baud rate");
                    r = this._readerCommunication.connect(Common.makeSetBaudAndLevelCommand(this._config, this._config.getBaudRate()), 1.5, this, this);
                    if (r != null && r.data != null && r.data.size() > 0 && r.data.get(0) != null && Common.getHexStringFromBytes(r.data.get(0)).equalsIgnoreCase("5669564F74656368320030000000480E")) {
                        UMLog.i(this.TAG, "connected");
                        return new Runnable(){

                            public void run() {
                                ConnectTask.this._readerCommunication.cxn_setConnected(null);
                            }
                        };
                    }
                } else {
                    UMLog.i(this.TAG, "Try to connect for UNIPAY with " + this._config.getBaudRate() + " baud rate");
                    r = this._readerCommunication.connect(Common.makeSetBaudAndLevelCommand(this._config, this._config.getBaudRate()), 3.0, this, this);
                }
                if (r.isCanceledOrFailed()) {
                    return null;
                }
                if (r.isParsed() && (pus = Common.PUSType.parse(r.data)) != Common.PUSType.INVALID) {
                    break;
                }
            } else {
                UMLog.i(this.TAG, "tone");
                this._tonePlayer.setPlayingTone(ToneType.T_2400Hz);
                this._ioManager.setDeviceMediaVolumeToMax();
                r = this._readerCommunication.sendCommand(null, 2.0, this, this);
                this._tonePlayer.setPlayingTone(null);
                if (r.isCanceledOrFailed()) {
                    return null;
                }
                if (r.isParsed() && (pus = Common.PUSType.parse(r.data)) != Common.PUSType.INVALID) break;
            }
            if (this.safeWait(0.4)) {
                return null;
            }
            ++reps;
        }
        if (this.isCanceled()) {
            return null;
        }
        if (pus == null || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
            UMLog.i(this.TAG, "timed out");
            return new Runnable(){

                public void run() {
                    Common.beginTimeEachCmd = Common.getCurrentTime();
                    ConnectTask.this._umrMsg.timeout(23);
                }
            };
        }
        UMLog.i(this.TAG, "connected " + pus.name);
        if (this._config.getVolumeLevelAdjust() > 1) {
            this._ioManager.setDeviceMediaVolumeToMaxMinusArg(1);
        }
        final Common.PUSType fpus = pus;
        return new Runnable(){

            public void run() {
                if (fpus.readerType != null) {
                    ConnectTask.this._readerCommunication.readerType_set(fpus.readerType);
                }
                Common.coverAllBaudRate = false;
                ConnectTask.this._readerCommunication.cxn_setConnected(ToneType.T_2000Hz);
                Common.beginTimeEachCmd = Common.getCurrentTime();
            }
        };
    }
}

