/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.util.Iterator;
import java.util.List;

public class SwipeUMTask
extends Task {
    private final double a;
    private byte[] b = null;

    public SwipeUMTask(TaskManager taskManager, ReaderCommunication readerCommunication, double d2) {
        super(taskManager, readerCommunication);
        this.a = d2;
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Swipe;
    }

    @Override
    protected void taskCleanup() {
        if (this._ioManager != null) {
            this._ioManager.notifyTaskFinished();
        }
    }

    @Override
    protected Runnable taskMain() {
        this._ioManager.getTonePlayer().setPlayingTone(ToneType.T_2000Hz);
        SwipeUMTask swipeUMTask = this;
        IOManager.RPDResult rPDResult = this._ioManager.recordPlayDecode(null, this.a, swipeUMTask, swipeUMTask, false, false, false);
        if (rPDResult.isCanceledOrFailed()) {
            this._ioManager.getTonePlayer().setPlayingTone(null);
            return null;
        }
        if (rPDResult.isTimedOut()) {
            return new Runnable(this){
                private /* synthetic */ SwipeUMTask a;
                {
                    this.a = swipeUMTask;
                }

                @Override
                public final void run() {
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG_PRO || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG || Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK) {
                        IDT_Device.readyForCardSwipe = true;
                    }
                    this.a._umrMsg.timeout(24);
                    this.a._ioManager.getTonePlayer().setPlayingTone(null);
                }
            };
        }
        return new Runnable(this){
            private /* synthetic */ SwipeUMTask a;
            {
                this.a = swipeUMTask;
            }

            @Override
            public final void run() {
                if (this.a.b != null) {
                    UMLog.i(this.a.TAG, "Response MSR Data - Runnable");
                    Common.Response.responesMSRData(this.a._umrMsg, this.a.b);
                    this.a._ioManager.getTonePlayer().setPlayingTone(null);
                }
            }
        };
    }

    @Override
    public boolean processResponse(List<byte[]> object) {
        boolean bl;
        block5: {
            Object object2 = object;
            object = this;
            Iterator<byte[]> iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                UMLog.i(((SwipeUMTask)object).TAG, "isResponseValid got: " + Common.getByteArrDesc((byte[])object2));
                UMLog.i(((SwipeUMTask)object).TAG, "isResponseValid got: " + Common.getHexStringFromBytes((byte[])object2));
                if (((Object)object2).length < 2) continue;
                if (Common.PUSType.parse((byte[])object2) != Common.PUSType.INVALID) {
                    UMLog.i(((SwipeUMTask)object).TAG, "ignored PUS");
                    continue;
                }
                Object object3 = object2;
                if (13 == object3[((Object)object3).length - 1] && ((Object)object2).length != 13) {
                    ((SwipeUMTask)object).b = (byte[])object2;
                    bl = true;
                    break block5;
                }
                if (2 == object2[1] || 2 == object2[0]) {
                    Object object4 = object2;
                    if (3 == object4[((Object)object4).length - 1]) {
                        ((SwipeUMTask)object).b = (byte[])object2;
                        bl = true;
                        break block5;
                    }
                }
                UMLog.i(((SwipeUMTask)object).TAG, "ignored ill-formed swipe data");
            }
            bl = false;
        }
        boolean bl2 = bl;
        return bl;
    }

    @Override
    public void processSound() {
        UMLog.i(this.TAG, "swipe detected");
        this.post(new Runnable(this){

            @Override
            public final void run() {
            }
        });
    }
}

