/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device;

import android.content.Context;
import com.idtechproducts.device.APDUResponseStruct;
import com.idtechproducts.device.ErrorCodeInfo;
import com.idtechproducts.device.ICCReaderStatusStruct;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.MSRSettingStruct;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;

public class IDT_UniPay {
    private IDT_Device device;

    public IDT_UniPay(OnReceiverListener callback, Context context) {
        this.device = new IDT_Device(callback, context);
        if (IDT_Device.getUSBBypass()) {
            IDT_Device._bypassDevice = ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY;
        } else {
            this.device.device_setDeviceType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY);
        }
    }

    public boolean device_setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY) {
            return this.device.device_setDeviceType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY);
        }
        if (deviceType == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB) {
            return this.device.device_setDeviceType(ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_USB);
        }
        return false;
    }

    public void registerListen() {
        this.device.registerListen();
    }

    public void unregisterListen() {
        this.device.unregisterListen();
    }

    public void release() {
        this.device.release();
    }

    public static void useUSBIntentFilter() {
        IDT_Device._isDeviceFilter = true;
    }

    public String config_getSDKVersion() {
        return this.device.config_getSDKVersion();
    }

    public String config_getXMLVersionInfo() {
        return this.device.config_getXMLVersionInfo();
    }

    public String phone_getInfoManufacture() {
        return this.device.phone_getInfoManufacture();
    }

    public String phone_getInfoModel() {
        return this.device.phone_getInfoModel();
    }

    public void log_setVerboseLoggingEnable(boolean enable) {
        this.device.log_setVerboseLoggingEnable(enable);
    }

    public void log_setSaveLogEnable(boolean enable) {
        this.device.log_setSaveLogEnable(enable);
    }

    public int log_deleteLogs() {
        return this.device.log_deleteLogs();
    }

    public void config_setXMLFileNameWithPath(String path) {
        this.device.config_setXMLFileNameWithPath(path);
    }

    public boolean config_loadingConfigurationXMLFile(boolean updateAutomatically) {
        return this.device.config_loadingConfigurationXMLFile(updateAutomatically);
    }

    public boolean device_connectWithProfile(StructConfigParameters profile) {
        return this.device.device_connectWithProfile(profile);
    }

    public boolean device_isConnected() {
        return this.device.device_isConnected();
    }

    public int msr_startMSRSwipe() {
        return this.device.msr_startMSRSwipe();
    }

    public void msr_cancelMSRSwipe() {
        this.device.msr_cancelMSRSwipe();
    }

    public int device_startRKI() {
        return this.device.device_startRKI();
    }

    public int autoConfig_start(String strXMLFilename) {
        return this.device.autoConfig_start(strXMLFilename);
    }

    public void autoConfig_stop() {
        this.device.autoConfig_stop();
    }

    public int device_enableTDES(ResDataStruct respData) {
        return this.device.device_enableTDES(respData);
    }

    public int device_enableAES(ResDataStruct respData) {
        return this.device.device_enableAES(respData);
    }

    public int device_calibrateReader(ResDataStruct respData) {
        return this.device.device_calibrateReader(respData);
    }

    public int device_getFirmwareVersion(StringBuilder version) {
        return this.device.device_getFirmwareVersion(version);
    }

    public int device_sendDataCommand(String cmd, boolean calcLRC, String data, ResDataStruct respData) {
        return this.device.device_sendDataCommand(cmd, calcLRC, data, respData);
    }

    public int device_sendDataCommand(String cmd, boolean calcLRC, String data, ResDataStruct respData, int timeout) {
        return this.device.device_sendDataCommand(cmd, calcLRC, data, respData, timeout);
    }

    public int device_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags) {
        return this.device.device_startTransaction(amount, amtOther, type, timeout, tags);
    }

    public int device_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags, boolean isFastEMV) {
        return this.device.device_startTransaction(amount, amtOther, type, timeout, tags, isFastEMV);
    }

    public int device_ReviewAudioJackSetting(ResDataStruct respData) {
        return this.device.device_ReviewAudioJackSetting(respData);
    }

    public int config_getSerialNumber(StringBuilder serialNumber) {
        return this.device.config_getSerialNumber(serialNumber);
    }

    public int config_getModelNumber(StringBuilder modNumber) {
        return this.device.config_getModelNumber(modNumber);
    }

    public int device_getKSN(ResDataStruct ksn) {
        return this.device.device_getKSN(ksn);
    }

    public int device_enableErrorNotification(ResDataStruct respData, boolean enable) {
        return this.device.device_enableErrorNotification(respData, enable);
    }

    public int device_enableExpDate(ResDataStruct respData, boolean enable) {
        return this.device.device_enableExpDate(respData, enable);
    }

    public int device_enableForceEncryption(ResDataStruct respData, boolean enable) {
        return this.device.device_enableForceEncryption(respData, enable);
    }

    public String device_getResponseCodeString(int errorCode) {
        return ErrorCodeInfo.getErrorCodeDescription(errorCode);
    }

    public ReaderInfo.DEVICE_TYPE device_getDeviceType() {
        return this.device.device_getDeviceType();
    }

    public int icc_getICCReaderStatus(ICCReaderStatusStruct ICCStatus) {
        return this.device.icc_getICCReaderStatus(ICCStatus);
    }

    public int icc_powerOnICC(ResDataStruct atrPPS) {
        return this.device.icc_powerOnICC(atrPPS);
    }

    public int icc_powerOffICC(ResDataStruct respData) {
        return this.device.icc_powerOffICC(respData);
    }

    public int device_rebootDevice() {
        return this.device.device_rebootDevice();
    }

    public int device_sendCommandDirectIO(String hexCommand, ResDataStruct respData) {
        return this.device.device_sendCommandDirectIO(hexCommand, respData);
    }

    public int icc_exchangeAPDU(byte[] dataAPDU, APDUResponseStruct response) {
        return this.device.icc_exchangeAPDU(dataAPDU, response);
    }

    public int icc_exchangeEncryptedAPDU(byte[] dataAPDU, byte[] ksn, APDUResponseStruct response) {
        return this.device.icc_exchangeEncryptedAPDU(dataAPDU, ksn, response);
    }

    public int icc_exchangeMultiAPDU(byte[] dataAPDU, ResDataStruct respData) {
        return this.device.icc_exchangeMultiAPDU(dataAPDU, respData);
    }

    public int icc_getAPDU_KSN(ResDataStruct resKSN) {
        return this.device.icc_getAPDU_KSN(resKSN);
    }

    public int icc_enableNotification(boolean enableNotifyICCStatus) {
        return this.device.icc_enableNotification(enableNotifyICCStatus);
    }

    public int icc_defaultSetting() {
        return this.device.icc_defaultSetting();
    }

    public int emv_retrieveApplicationData(String aid, ResDataStruct respData) {
        return this.device.emv_retrieveApplicationData(aid, respData);
    }

    public int emv_removeApplicationData(String aid, ResDataStruct respData) {
        return this.device.emv_removeApplicationData(aid, respData);
    }

    public int emv_setApplicationData(String aid, byte[] TLV, ResDataStruct respData) {
        return this.device.emv_setApplicationData(aid, TLV, respData);
    }

    public int emv_retrieveTerminalData(ResDataStruct respData) {
        return this.device.emv_retrieveTerminalData(respData);
    }

    public int emv_removeTerminalData(ResDataStruct respData) {
        return this.device.emv_removeTerminalData(respData);
    }

    public int emv_setTerminalData(byte[] data, ResDataStruct respData) {
        return this.device.emv_setTerminalData(data, respData);
    }

    public int emv_retrieveAidList(ResDataStruct respData) {
        return this.device.emv_retrieveAidList(respData);
    }

    public int emv_retrieveCAPK(byte[] data, ResDataStruct respData) {
        return this.device.emv_retrieveCAPK(data, respData);
    }

    public int emv_removeCAPK(byte[] data, ResDataStruct respData) {
        return this.device.emv_removeCAPK(data, respData);
    }

    public int emv_setCAPK(byte[] data, ResDataStruct respData) {
        return this.device.emv_setCAPK(data, respData);
    }

    public int emv_retrieveCAPKList(ResDataStruct respData) {
        return this.device.emv_retrieveCAPKList(respData);
    }

    public int emv_retrieveCRL(ResDataStruct respData) {
        return this.device.emv_retrieveCRL(respData);
    }

    public int emv_removeCRL(byte[] data, ResDataStruct respData) {
        return this.device.emv_removeCRL(data, respData);
    }

    public int emv_setCRL(byte[] data, ResDataStruct respData) {
        return this.device.emv_setCRL(data, respData);
    }

    public int emv_startTransaction(double amount, double amtOther, int type, int timeout, byte[] tags, boolean forceOnline) {
        return this.device.emv_startTransaction(amount, amtOther, type, timeout, tags, forceOnline);
    }

    public int emv_authenticateTransaction(byte[] tags) {
        return this.device.emv_authenticateTransaction(tags);
    }

    public int device_setPMCStatus(byte[] idleSleepTime, ResDataStruct respData) {
        return this.device.device_setPMCStatus(idleSleepTime, respData);
    }

    public int device_getPMCStatus(ResDataStruct respData) {
        return this.device.device_getPMCStatus(respData);
    }

    public int device_shutOffPower(ResDataStruct respData) {
        return this.device.device_shutOffPower(respData);
    }

    public int msr_reviewAllSetting(MSRSettingStruct msrSetting) {
        return this.device.msr_reviewAllSetting(msrSetting);
    }

    public int msr_defaultAllSetting() {
        return this.device.msr_defaultAllSetting();
    }

    public int msr_getSingleSetting(byte funcID, byte[] response) {
        return this.device.msr_getSingleSetting(funcID, response);
    }

    public int msr_setSingleSetting(byte funcID, byte setData) {
        return this.device.msr_setSingleSetting(funcID, setData);
    }

    public int device_getBatteryVoltage(StringBuilder batteryInfo) {
        return this.device.device_getBatteryVoltage(batteryInfo);
    }
}

