/*
 * Decompiled with CFR 0.152.
 */
package com.zeamster.paymentsdk.service;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTEMVData;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_VP3300;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.bluetooth.BluetoothLEController;
import com.zeamster.paymentsdk.R;
import com.zeamster.paymentsdk.resthandler.HttpMethod;
import com.zeamster.paymentsdk.service.PaymentMethod;
import com.zeamster.paymentsdk.transaction.EMVTransaction;
import com.zeamster.paymentsdk.transaction.EncryptionFormat;
import com.zeamster.paymentsdk.transaction.EntryModeId;
import com.zeamster.paymentsdk.transaction.ICallbackEMV;
import com.zeamster.paymentsdk.transaction.TransactionAction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class IDTECHBLEService
implements OnReceiverListener {
    private static final int MY_PERMISSIONS_REQUEST_READ_CONTACTS = 3300;
    private static final int DEFAULT_TIMEOUT = 10000;
    private final int EMV_TIMEOUT = 90;
    private static final String PAYMENT_METHOD = "payment_method";
    private static final String ACTION = "action";
    private static final String E_FORMAT = "e_format";
    private static final String ENTRY_MODE_ID = "entry_mode_id";
    private static final String E_TRACK_DATA = "e_track_data";
    private static final String E_SERIAL_NUMBER = "e_serial_number";
    private String btleDeviceAddress = "";
    private String btleDeviceName = "";
    private String message = "";
    private String log = "";
    private boolean btleDeviceRegistered;
    private boolean isReaderConnected = false;
    private IDT_VP3300 idt_vp3300;
    private ScanCallback scanCallback;
    private BluetoothAdapter mBtAdapter;
    private BluetoothLeScanner bluetoothLeScanner;
    private ArrayList<String> deviceNames = new ArrayList();
    private ArrayList<BluetoothDevice> discoveredDevices = new ArrayList();
    private ArrayList<Integer> scanErrorCodes = new ArrayList();
    private Handler handler = new Handler();
    private ReaderInfo.DEVICE_TYPE deviceType;
    private ICallbackEMV callback;
    private Activity context;
    private boolean isPluginRequest;
    private EMVTransaction emvTransaction;
    HashMap<String, Object> payLoad;
    TransactionAction transactionAction;

    public IDTECHBLEService(ICallbackEMV callbackEMV, Activity context, ReaderInfo.DEVICE_TYPE deviceType) {
        this.callback = callbackEMV;
        this.context = context;
        this.deviceType = deviceType;
        this.createDeviceInstance();
    }

    public HashMap<String, Object> getPayLoad() {
        return this.payLoad;
    }

    public void setPayLoad(HashMap<String, Object> payLoad) {
        this.payLoad = payLoad;
    }

    public TransactionAction getTransactionAction() {
        return this.transactionAction;
    }

    public void setTransactionAction(TransactionAction transactionAction) {
        this.transactionAction = transactionAction;
    }

    public EMVTransaction getEmvTransaction() {
        return this.emvTransaction;
    }

    public void setEmvTransaction(EMVTransaction emvTransaction) {
        this.emvTransaction = emvTransaction;
    }

    public boolean isPluginRequest() {
        return this.isPluginRequest;
    }

    public void isPluginRequest(boolean pluginRequest) {
        this.isPluginRequest = pluginRequest;
    }

    public ReaderInfo.DEVICE_TYPE getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(ReaderInfo.DEVICE_TYPE deviceType) {
        this.deviceType = deviceType;
    }

    public IDT_VP3300 getIdt_vp3300() {
        return this.idt_vp3300;
    }

    public ArrayList<Integer> getScanErrorCodes() {
        return this.scanErrorCodes;
    }

    private void createDeviceInstance() {
        switch (this.deviceType) {
            case DEVICE_VP3300_BT: {
                if (this.idt_vp3300 != null) {
                    this.idt_vp3300.unregisterListen();
                    this.idt_vp3300.release();
                    this.idt_vp3300 = null;
                }
                this.idt_vp3300 = new IDT_VP3300(this, (Context)this.context);
                this.idt_vp3300.device_setDeviceType(this.deviceType);
                this.idt_vp3300.registerListen();
            }
        }
        this.loadXMLfile();
    }

    private void loadXMLfile() {
        String fileNameWithPath = this.getConfigurationFileFromRaw();
        if (!this.isFileExist(fileNameWithPath)) {
            fileNameWithPath = null;
        }
        this.idt_vp3300.config_setXMLFileNameWithPath(fileNameWithPath);
        Log.d((String)"Demo Info >>>>>", (String)"loadingConfigurationXMLFile begin.");
        this.idt_vp3300.config_loadingConfigurationXMLFile(true);
    }

    private String getConfigurationFileFromRaw() {
        return this.getXMLFileFromRaw("idt_unimagcfg_default.xml", R.raw.idt_unimagcfg_default);
    }

    private String getXMLFileFromRaw(String fileName, int res) {
        String fileNameWithPath = null;
        fileNameWithPath = fileName;
        try {
            InputStream in = this.context.getResources().openRawResource(res);
            int length = in.available();
            byte[] buffer = new byte[length];
            in.read(buffer);
            in.close();
            this.context.deleteFile(fileNameWithPath);
            FileOutputStream fout = this.context.openFileOutput(fileNameWithPath, 0);
            fout.write(buffer);
            fout.close();
            File fileDir = this.context.getFilesDir();
            fileNameWithPath = fileDir.getParent() + File.separator + fileDir.getName();
            fileNameWithPath = fileNameWithPath + File.separator + fileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            fileNameWithPath = null;
        }
        return fileNameWithPath;
    }

    private boolean isFileExist(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public ArrayList<String> scanForDevices(final String searchString, long timeout) {
        this.scanCallback = new ScanCallback(){

            public void onScanResult(int callbackType, ScanResult result) {
                if (searchString.equalsIgnoreCase("*") || result.getDevice().getName() != null && result.getDevice().getName().startsWith(searchString) || result.getDevice().getAddress() != null && result.getDevice().getAddress().startsWith(searchString)) {
                    for (BluetoothDevice bluetoothDevice : IDTECHBLEService.this.discoveredDevices) {
                        if (!bluetoothDevice.getAddress().contentEquals(result.getDevice().getAddress())) continue;
                        return;
                    }
                    IDTECHBLEService.this.discoveredDevices.add(result.getDevice());
                    if (result.getDevice().getName() != null && !result.getDevice().getName().isEmpty()) {
                        IDTECHBLEService.this.deviceNames.add(result.getDevice().getName());
                    } else {
                        IDTECHBLEService.this.deviceNames.add(result.getDevice().getAddress());
                    }
                    IDTECHBLEService.this.callback.deviceScanResponse(result.getDevice().getAddress(), result.getDevice().getName());
                }
            }

            public void onBatchScanResults(List<ScanResult> results) {
                for (ScanResult scanResult : results) {
                    this.onScanResult(1, scanResult);
                }
            }

            public void onScanFailed(int errorCode) {
                IDTECHBLEService.this.scanErrorCodes.add(errorCode);
            }
        };
        if (timeout < 10000L) {
            timeout = 10000L;
        }
        this.scanLeDevice(timeout);
        return this.deviceNames;
    }

    private void scanLeDevice(long timeout) {
        if (this.mBtAdapter == null) {
            this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        this.bluetoothLeScanner = this.mBtAdapter.getBluetoothLeScanner();
        if (!this.isPluginRequest()) {
            ActivityCompat.requestPermissions((Activity)this.context, (String[])new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"}, (int)3300);
        }
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                IDTECHBLEService.this.bluetoothLeScanner.stopScan(IDTECHBLEService.this.scanCallback);
                IDTECHBLEService.this.callback.deviceScanCompleted();
            }
        }, timeout);
        this.bluetoothLeScanner.startScan(this.scanCallback);
    }

    public void stopScanForDevices() {
        this.bluetoothLeScanner.stopScan(this.scanCallback);
    }

    public boolean connectDeviceByAddress(String address) {
        if (address != null && !address.isEmpty()) {
            if (address.length() == 17 && address.charAt(2) == ':' && address.charAt(5) == ':' && address.charAt(8) == ':' && address.charAt(11) == ':' && address.charAt(14) == ':') {
                String deviceAddress;
                BluetoothDevice bluetoothDevice = this.getDeviceByAddress(address);
                String string = deviceAddress = bluetoothDevice != null ? bluetoothDevice.getAddress() : "";
                if (deviceAddress != null) {
                    BluetoothLEController.setBluetoothDevice(bluetoothDevice);
                    this.btleDeviceAddress = deviceAddress;
                    String string2 = this.btleDeviceName = bluetoothDevice != null ? bluetoothDevice.getName() : "";
                    if (!this.btleDeviceRegistered) {
                        this.idt_vp3300.registerListen();
                        this.btleDeviceRegistered = true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean connectDeviceByName(String deviceName) {
        BluetoothDevice bluetoothDevice;
        if (deviceName != null && !deviceName.isEmpty() && (bluetoothDevice = this.getDeviceByName(deviceName)) != null) {
            BluetoothLEController.setBluetoothDevice(bluetoothDevice);
            this.btleDeviceName = bluetoothDevice.getName();
            this.btleDeviceAddress = bluetoothDevice.getAddress();
            if (!this.btleDeviceRegistered) {
                this.idt_vp3300.registerListen();
                this.btleDeviceRegistered = true;
            }
            return true;
        }
        return false;
    }

    private BluetoothDevice getDeviceByName(String name) {
        for (BluetoothDevice bluetoothDevice : this.discoveredDevices) {
            if (bluetoothDevice.getName() == null || !bluetoothDevice.getName().equalsIgnoreCase(name)) continue;
            return bluetoothDevice;
        }
        return null;
    }

    private BluetoothDevice getDeviceByAddress(String address) {
        for (BluetoothDevice bluetoothDevice : this.discoveredDevices) {
            if (bluetoothDevice.getAddress() == null || !bluetoothDevice.getAddress().equalsIgnoreCase(address)) continue;
            return bluetoothDevice;
        }
        return null;
    }

    public String getConnectedDeviceAndStatus() {
        String device = "UNKNOWN";
        if (this.btleDeviceName != null && !this.btleDeviceName.isEmpty()) {
            device = this.btleDeviceName;
        } else if (this.btleDeviceAddress != null && !this.btleDeviceAddress.isEmpty()) {
            device = this.btleDeviceAddress;
        }
        String status = "DISCONNECTED";
        if (this.isReaderConnected) {
            status = "CONNECTED";
        }
        return status + " - " + device;
    }

    public void runInitialSetup() {
        this.loadDefaultAIDs();
        this.loadDefaultCAPKs();
    }

    private void setTerminalData() {
        ResDataStruct setTerminalData = new ResDataStruct();
        byte[] term = Common.getByteArray("5f3601029f1a0208409f3501229f330360f8c89f4005f00000a0019f1e085465726d696e616c9f150212349f160f3030303030303030303030303030309f1c0838373635343332319f4e2231303732312057616c6b65722053742e20437970726573732c204341202c5553412edf260101df1008656e667265737a68df110101df270100dfee150101dfee160100dfee170107dfee180180dfee1e08f0dc3cf0c29e9400dfee1f0180dfee1b083030303135313030dfee20013cdfee21010adfee2203323c3c");
        int rt = this.idt_vp3300.emv_setTerminalData(term, setTerminalData);
        if (rt == 0) {
            Log.d((String)"", (String)"Set Terminal Successful:");
        } else {
            Log.d((String)"setTerminalData", (String)("Save Terminal failed Error Code: " + rt + " : " + this.idt_vp3300.device_getResponseCodeString(rt)));
        }
    }

    private void loadDefaultAIDs() {
    }

    private void loadDefaultCAPKs() {
    }

    private void sendResponse() {
        this.callback.deviceMessage(this.message);
        this.callback.outputLogs(this.log);
    }

    public void getFirmwareDetail() {
        this.message = "Getting Firmware\n";
        this.log = "";
        this.sendResponse();
        StringBuilder sb = new StringBuilder();
        int ret = this.idt_vp3300.device_getFirmwareVersion(sb);
        if (ret == 0) {
            this.message = this.message + "Firmware Version: " + sb.toString();
        } else {
            this.message = this.message + "GetFirmwareVersion: Failed\n";
            this.message = this.message + "Status: " + this.idt_vp3300.device_getResponseCodeString(ret) + "";
        }
        this.log = "";
        this.sendResponse();
    }

    public void getSerialNumber() {
        this.message = "Getting Serial Number\n";
        this.log = "";
        this.sendResponse();
        StringBuilder sb = new StringBuilder();
        int ret = this.idt_vp3300.config_getSerialNumber(sb);
        if (ret == 0) {
            this.message = this.message + "Serial Number: " + sb.toString();
        } else {
            this.message = this.message + "Getting Serial Number Failed!\n";
            this.message = this.message + "Status: " + this.idt_vp3300.device_getResponseCodeString(ret) + "";
        }
        this.log = "";
        this.sendResponse();
    }

    public void getAIDSettings() {
        this.message = "Getting AID Settings..\n";
        this.log = "";
        this.sendResponse();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveAidList(resData);
        if (ret == 0) {
            this.message = this.message + "AID Settings: " + resData.stringArray.toString();
        } else {
            this.message = this.message + "Getting AID Settings Failed!\n";
            this.message = this.message + "Status: " + this.idt_vp3300.device_getResponseCodeString(ret) + "";
        }
        this.log = "";
        this.sendResponse();
    }

    public void getCAPKSettings() {
        this.message = "Getting CAPK Settings\n";
        this.log = "";
        this.sendResponse();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveCAPKList(resData);
        if (ret == 0) {
            this.message = this.message + "CAPK Settings: " + resData.stringArray.toString();
        } else {
            this.message = this.message + "Getting CAPK Settings Failed!\n";
            this.message = this.message + "Status: " + this.idt_vp3300.device_getResponseCodeString(ret) + "";
        }
        this.log = "";
        this.sendResponse();
    }

    public void getTerminalSettings() {
        this.message = "Getting Terminal Settings..\n";
        this.log = "";
        this.sendResponse();
        ResDataStruct resData = new ResDataStruct();
        int ret = this.idt_vp3300.emv_retrieveTerminalData(resData);
        if (ret == 0) {
            this.message = this.message + "Terminal Settings: " + resData.stringArray.toString();
        } else {
            this.message = this.message + "Getting Terminal Settings Failed!\n";
            this.message = this.message + "Status: " + this.idt_vp3300.device_getResponseCodeString(ret) + "";
        }
        this.log = "";
        this.sendResponse();
    }

    public void startEMVTransaction() {
        this.log = "";
        this.message = "Starting EMV Transaction\n";
        this.sendResponse();
        IDT_VP3300.emv_allowFallback(true);
        IDT_VP3300.emv_setAutoCompleteTransaction(true);
        byte[] tags = new byte[]{-33, -17, 31, 2, 1, 0};
        int result = IDT_VP3300.emv_getAutoAuthenticateTransaction() ? this.idt_vp3300.emv_startTransaction(1.0, 0.0, 0, 90, tags, false) : this.idt_vp3300.emv_startTransaction(1.0, 0.0, 0, 90, null, false);
        String str = Common.getHexStringFromBytes(tags);
        if (result == 16) {
            this.log = "";
            this.message = "Transaction started.\n";
            this.message = this.message + "emv_startTransaction: " + this.idt_vp3300.device_getResponseCodeString(result);
            this.sendResponse();
        } else {
            this.log = "";
            this.message = "Transaction could not start!\n";
            this.message = this.message + "emv_startTransaction: " + this.idt_vp3300.device_getResponseCodeString(result);
            this.sendResponse();
        }
    }

    public void completeEMVTransaction() {
        this.log = "";
        this.message = "Completing EMV Transaction..\n";
        this.sendResponse();
        this.idt_vp3300.emv_completeTransaction(false, new byte[5], new byte[5], new byte[5], new byte[5]);
    }

    public void cancelEMVTransaction() {
        this.log = "";
        this.message = "Cancelling EMV Transaction..\n";
        this.sendResponse();
        ResDataStruct resData = new ResDataStruct();
        this.idt_vp3300.emv_cancelTransaction(resData);
    }

    public void startMSRTransaction() {
        this.log = "";
        this.message = "Starting Swipe/Tap Transaction\n";
        this.sendResponse();
        this.idt_vp3300.msr_startMSRSwipe();
    }

    public void cancelMSRSwipe() {
        this.log = "";
        this.message = "Cancelling Swipe/Tap Transaction\n";
        this.sendResponse();
        this.idt_vp3300.msr_cancelMSRSwipe();
    }

    @Override
    public void swipeMSRData(IDTMSRData idtmsrData) {
        this.message = idtmsrData.cardData[0] != 1 && idtmsrData.track1Length == 0 && idtmsrData.track2Length == 0 && idtmsrData.track3Length == 0 ? "Swipe/Tap data didn't read correctly" : "Swipe/Tap Read Successfully";
        this.log = Common.parse_MSRData(this.idt_vp3300.device_getDeviceType(), idtmsrData);
        this.sendResponse();
        String DFEE23 = "";
        if (idtmsrData != null && idtmsrData.unencryptedTags != null) {
            byte[] data = idtmsrData.unencryptedTags.get("DFEE23");
            DFEE23 = Common.getHexStringFromBytes(data);
        }
        StringBuilder KSN = new StringBuilder();
        if (idtmsrData != null && idtmsrData.KSN != null && idtmsrData.KSN.length > 0) {
            for (int i = 0; i < idtmsrData.KSN.length; ++i) {
                KSN.append(String.format(Locale.US, "%02x", idtmsrData.KSN[i]));
            }
        }
        this.payLoad.put(PAYMENT_METHOD, PaymentMethod.CC.name().toLowerCase());
        this.payLoad.put(ACTION, this.transactionAction.name().toLowerCase());
        this.payLoad.put(E_FORMAT, EncryptionFormat.IDTECH.toString().toLowerCase());
        this.payLoad.put(ENTRY_MODE_ID, EntryModeId.Swipe.name());
        this.payLoad.put(E_TRACK_DATA, DFEE23);
        this.payLoad.put(E_SERIAL_NUMBER, KSN.toString());
        this.emvTransaction.restServiceClient.setRequestBody(this.emvTransaction.convertToTransactionPayload(this.payLoad));
        this.emvTransaction.perform(HttpMethod.POST);
    }

    @Override
    public void lcdDisplay(int mode, String[] lines, int timeout) {
        if (mode == 1) {
            this.idt_vp3300.emv_lcdControlResponse((byte)mode, (byte)1);
        } else if (mode == 8) {
            this.idt_vp3300.emv_lcdControlResponse((byte)mode, (byte)1);
        } else {
            this.message = lines[0];
            this.callback.deviceMessage(this.message);
        }
    }

    @Override
    public void lcdDisplay(int i, String[] strings, int i1, byte[] bytes, byte b) {
    }

    @Override
    public void emvTransactionData(IDTEMVData idtemvData) {
        String str;
        byte[] data;
        StringBuilder sb;
        Set<String> keys;
        this.log = this.log + "\r\n";
        this.log = this.log + Common.emvErrorCodes(idtemvData.result);
        this.log = this.log + "\r\n";
        this.log = idtemvData.result == 16 ? this.log + "Start transaction response:\r\n" : (idtemvData.result == 4 ? this.log + "\r\nAuthentication response:\r\n" : this.log + "\r\nComplete Transaction response:\r\n");
        if (idtemvData.unencryptedTags != null && !idtemvData.unencryptedTags.isEmpty()) {
            this.log = this.log + "Unencrypted Tags:\r\n";
            keys = idtemvData.unencryptedTags.keySet();
            sb = new StringBuilder();
            for (String key : keys) {
                sb.append(key).append(": ");
                data = idtemvData.unencryptedTags.get(key);
                sb.append(Common.getHexStringFromBytes(data)).append("\r\n");
            }
            this.log = this.log + sb.toString();
        }
        if (idtemvData.maskedTags != null && !idtemvData.maskedTags.isEmpty()) {
            this.log = this.log + "Masked Tags:\r\n";
            keys = idtemvData.maskedTags.keySet();
            sb = new StringBuilder();
            for (String key : keys) {
                sb.append(key).append(": ");
                data = idtemvData.maskedTags.get(key);
                sb.append(Common.getHexStringFromBytes(data)).append("\r\n");
            }
            this.log = this.log + sb.toString();
        }
        if (idtemvData.encryptedTags != null && !idtemvData.encryptedTags.isEmpty()) {
            this.log = this.log + "Encrypted Tags:\r\n";
            keys = idtemvData.encryptedTags.keySet();
            sb = new StringBuilder();
            for (String key : keys) {
                sb.append(key).append(": ");
                data = idtemvData.encryptedTags.get(key);
                sb.append(Common.getHexStringFromBytes(data)).append("\r\n");
            }
            this.log = this.log + sb.toString();
        }
        this.sendResponse();
        if (idtemvData.result == 4) {
            byte[] response = new byte[]{48, 48};
            int result = this.idt_vp3300.emv_completeTransaction(false, response, null, null, null);
            str = this.idt_vp3300.device_getResponseCodeString(result);
            Log.d((String)"emv_completeTransatn: ", (String)str);
        } else if (idtemvData.result == 16) {
            int result = this.idt_vp3300.emv_authenticateTransaction(null);
            str = this.idt_vp3300.device_getResponseCodeString(result);
            Log.d((String)"emv_authenticateTrans: ", (String)str);
        }
        str = "emv_authenticateTransaction: " + this.idt_vp3300.device_getResponseCodeString(idtemvData.result);
        Log.d((String)"emv_authenticateTrnst: ", (String)str);
    }

    @Override
    public void deviceConnected() {
        this.isReaderConnected = true;
        this.callback.deviceConnected(this.getConnectedDeviceAndStatus());
    }

    @Override
    public void deviceDisconnected() {
        this.isReaderConnected = false;
        this.callback.deviceDisconnected(this.getConnectedDeviceAndStatus());
    }

    @Override
    public void timeout(int i) {
    }

    @Override
    public void autoConfigCompleted(StructConfigParameters structConfigParameters) {
    }

    @Override
    public void autoConfigProgress(int i) {
    }

    @Override
    public void msgRKICompleted(String s) {
    }

    @Override
    public void ICCNotifyInfo(byte[] bytes, String s) {
    }

    @Override
    public void msgBatteryLow() {
    }

    @Override
    public void LoadXMLConfigFailureInfo(int i, String s) {
    }

    @Override
    public void msgToConnectDevice() {
    }

    @Override
    public void msgAudioVolumeAjustFailed() {
    }

    @Override
    public void dataInOutMonitor(byte[] bytes, boolean b) {
    }
}

