/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwipeTask
extends Task {
    public final double d;
    public byte[] e = null;

    public SwipeTask(TaskManager umMan, ReaderCommunication readerCommunication, double timeoutIntervalSec) {
        super(umMan, readerCommunication);
        this.d = timeoutIntervalSec;
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Swipe;
    }

    @Override
    public void taskCleanup() {
        IOManager this_ = ((Task)((Object)this_))._ioManager;
        if (this_ != null) {
            this_.notifyTaskFinished();
        }
    }

    @Override
    public Runnable taskMain() {
        SwipeTask swipeTask = this;
        IOManager.RPDResult rPDResult = this._readerCommunication.waitResponse(this.d, swipeTask, swipeTask);
        if (rPDResult.isCanceledOrFailed()) {
            return null;
        }
        if (rPDResult.isTimedOut()) {
            return new Runnable(){

                public void run() {
                    SwipeTask.this._umrMsg.timeout(24);
                }
            };
        }
        return new Runnable(){

            public void run() {
                SwipeTask swipeTask = runnable.SwipeTask.this;
                if (swipeTask.e != null) {
                    UMLog.i(swipeTask.TAG, "Response MSR Data - Runnable");
                    Runnable runnable = runnable.SwipeTask.this;
                    Common.Response.responesMSRData(((Task)runnable)._umrMsg, ((SwipeTask)runnable).e);
                }
            }
        };
    }

    @Override
    public boolean processResponse(List<byte[]> response) {
        Iterator<byte[]> iterator = response.iterator();
        while (true) {
            block8: {
                boolean bl;
                block6: {
                    byte[] byArray;
                    block7: {
                        block5: {
                            if (iterator.hasNext()) break block5;
                            bl = false;
                            break block6;
                        }
                        byArray = iterator.next();
                        UMLog.i(this.TAG, "got: " + Common.getByteArrDesc(byArray));
                        if (byArray.length < 2) continue;
                        if (Common.PUSType.parse(byArray) != Common.PUSType.INVALID) {
                            UMLog.i(this.TAG, "ignored PUS");
                            continue;
                        }
                        if (13 != byArray[byArray.length - 1]) break block7;
                        this.e = byArray;
                        bl = true;
                        break block6;
                    }
                    if (2 != byArray[1] && 2 != byArray[0] || 3 != byArray[byArray.length - 1]) break block8;
                    this.e = byArray;
                    bl = true;
                }
                return bl;
            }
            UMLog.i(this.TAG, "ignored ill-formed swipe data");
        }
    }

    @Override
    public void processSound() {
        SwipeTask swipeTask = this;
        UMLog.i(swipeTask.TAG, "swipe detected");
        swipeTask.post(new Runnable(this){

            public void run() {
            }
        });
    }
}

